/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.core;

import io.openvidu.java.client.Connection;
import io.openvidu.java.client.ConnectionProperties;
import io.openvidu.java.client.ConnectionType;
import io.openvidu.java.client.OpenVidu;
import io.openvidu.java.client.OpenViduException;
import io.openvidu.java.client.OpenViduHttpException;
import io.openvidu.java.client.OpenViduRole;
import io.openvidu.java.client.Session;
import io.openvidu.java.client.SessionProperties;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.vrspace.server.obj.Client;
import org.vrspace.server.obj.World;

@Component
public class StreamManager {
    private static final Logger log = LoggerFactory.getLogger(StreamManager.class);
    public static final String serviceId = "OpenVidu";
    @Value(value="#{systemProperties['openvidu.publicurl'] ?: '${openvidu.publicurl:none}' }")
    private String openViduUrl;
    @Value(value="#{systemProperties['openvidu.secret'] ?: '${openvidu.secret:none}' }")
    private String openViduSecret;
    private Map<String, Session> sessions = new ConcurrentHashMap<String, Session>();

    private Session startStreamingSession(String name) throws OpenViduException {
        Session ret = null;
        OpenVidu openVidu = new OpenVidu(this.openViduUrl, this.openViduSecret);
        SessionProperties properties = new SessionProperties.Builder().customSessionId(name).build();
        try {
            ret = openVidu.createSession(properties);
            this.sessions.put(name, ret);
            log.info("Created streaming session " + name);
        }
        catch (OpenViduHttpException e) {
            if (e.getStatus() == 409) {
                ret = this.sessions.get(name);
                if (ret == null) {
                    throw e;
                }
            }
            throw e;
        }
        return ret;
    }

    private String generateToken(Session session, Client client) throws OpenViduException {
        ConnectionProperties connectionProperties = new ConnectionProperties.Builder().type(ConnectionType.WEBRTC).role(OpenViduRole.PUBLISHER).data(client.getId().toString()).build();
        String token = null;
        try {
            token = session.createConnection(connectionProperties).getToken();
        }
        catch (OpenViduHttpException e) {
            if (e.getStatus() == 404) {
                log.error("Error generating token - session not found. Creating new session", (Throwable)e);
                session = this.startStreamingSession(session.getSessionId());
                token = session.createConnection(connectionProperties).getToken();
            }
            throw e;
        }
        return token;
    }

    public void disconnect(Client client, String worldName) throws OpenViduException {
        Session session;
        if (client.getToken(serviceId) != null && worldName != null && (session = this.sessions.get(worldName)) != null) {
            session.fetch();
            List activeConnections = session.getActiveConnections();
            log.debug("Disconnecting client " + String.valueOf(client.getId()) + ", current active connections " + activeConnections.size());
            for (Connection connection : activeConnections) {
                if (!client.getId().toString().equals(connection.getServerData())) continue;
                session.forceDisconnect(connection);
                client.clearToken(serviceId);
                log.debug("Disconnected client " + String.valueOf(client.getId()) + " from world " + worldName);
                if (activeConnections.size() > 1) break;
                this.sessions.remove(worldName);
                log.info("Removed streaming session " + worldName);
                break;
            }
        }
    }

    public void join(Client client, World world) {
        if (!"none".equals(this.openViduUrl) && !"none".equals(this.openViduSecret)) {
            try {
                this.disconnect(client, world.getName());
            }
            catch (OpenViduException e) {
                log.error("Failed to disconnect client " + String.valueOf(client), (Throwable)e);
            }
            String sessionName = world.getToken();
            if (sessionName == null) {
                sessionName = world.getName();
            }
            try {
                Session session = this.startStreamingSession(sessionName);
                try {
                    String token = this.generateToken(session, client);
                    client.setToken(serviceId, token);
                    log.debug("Client " + String.valueOf(client.getId()) + " joined session " + world.getName() + " with token " + token);
                }
                catch (OpenViduException e) {
                    log.error("Can't generate OpenVidu token", (Throwable)e);
                }
            }
            catch (OpenViduException e) {
                log.error("Can't start streaming session " + sessionName, (Throwable)e);
            }
        }
    }
}

