/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.vrspace.server.obj.Client;
import org.vrspace.server.obj.Ownership;
import org.vrspace.server.obj.VRObject;
import org.vrspace.server.types.ID;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class VREvent {
    private Map<String, Long> object = new LinkedHashMap<String, Long>(1);
    private Map<String, Object> changes = new LinkedHashMap<String, Object>();
    private LocalDateTime timestamp = LocalDateTime.now(ZoneId.of("UTC"));
    @JsonIgnore
    private String className;
    @JsonIgnore
    private Long id;
    @JsonIgnore
    private VRObject source;
    @JsonIgnore
    private Client client;
    @JsonIgnore
    private String payload;
    @JsonIgnore
    private Ownership ownership;

    public VREvent(VRObject source, Client client) {
        this(source);
        this.client = client;
    }

    public VREvent(VRObject source) {
        this.object.put(source.getClass().getSimpleName(), source.getId());
        this.source = source;
    }

    public VREvent addChange(String field, Object value) {
        this.changes.put(field, value);
        return this;
    }

    @JsonIgnore
    public String getSourceClassName() {
        if (this.className == null) {
            this.className = this.object.keySet().iterator().next();
        }
        return this.className;
    }

    @JsonIgnore
    public Long getSourceId() {
        if (this.id == null) {
            this.id = this.object.values().iterator().next();
        }
        return this.id;
    }

    @JsonIgnore
    public ID getSourceID() {
        return new ID(this.getSourceClassName(), this.getSourceId());
    }

    @JsonIgnore
    public boolean sourceIs(VRObject obj) {
        return this.getSourceId().equals(obj.getId()) && this.getSourceClassName().equals(obj.getClass().getSimpleName());
    }

    @JsonIgnore
    public boolean isOwner() {
        return this.getSource().equals(this.getClient()) || this.ownership != null && this.getSource() != null && this.ownership.getOwned().equals(this.getSource()) && this.ownership.getOwner().equals(this.getClient());
    }

    @Generated
    public Map<String, Long> getObject() {
        return this.object;
    }

    @Generated
    public Map<String, Object> getChanges() {
        return this.changes;
    }

    @Generated
    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public String getClassName() {
        return this.className;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public VRObject getSource() {
        return this.source;
    }

    @Generated
    public Client getClient() {
        return this.client;
    }

    @Generated
    public String getPayload() {
        return this.payload;
    }

    @Generated
    public Ownership getOwnership() {
        return this.ownership;
    }

    @Generated
    public void setObject(Map<String, Long> object) {
        this.object = object;
    }

    @Generated
    public void setChanges(Map<String, Object> changes) {
        this.changes = changes;
    }

    @Generated
    public void setTimestamp(LocalDateTime timestamp) {
        this.timestamp = timestamp;
    }

    @JsonIgnore
    @Generated
    public void setClassName(String className) {
        this.className = className;
    }

    @JsonIgnore
    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @JsonIgnore
    @Generated
    public void setSource(VRObject source) {
        this.source = source;
    }

    @JsonIgnore
    @Generated
    public void setClient(Client client) {
        this.client = client;
    }

    @JsonIgnore
    @Generated
    public void setPayload(String payload) {
        this.payload = payload;
    }

    @JsonIgnore
    @Generated
    public void setOwnership(Ownership ownership) {
        this.ownership = ownership;
    }

    @Generated
    public String toString() {
        return "VREvent(object=" + String.valueOf(this.getObject()) + ", changes=" + String.valueOf(this.getChanges()) + ", timestamp=" + String.valueOf(this.getTimestamp()) + ", className=" + this.getClassName() + ", id=" + String.valueOf(this.getId()) + ", source=" + String.valueOf(this.getSource()) + ", client=" + String.valueOf(this.getClient()) + ", payload=" + this.getPayload() + ", ownership=" + String.valueOf(this.getOwnership()) + ")";
    }

    @Generated
    public VREvent() {
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VREvent)) {
            return false;
        }
        VREvent other = (VREvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Map<String, Long> this$object = this.getObject();
        Map<String, Long> other$object = other.getObject();
        if (this$object == null ? other$object != null : !((Object)this$object).equals(other$object)) {
            return false;
        }
        Map<String, Object> this$changes = this.getChanges();
        Map<String, Object> other$changes = other.getChanges();
        if (this$changes == null ? other$changes != null : !((Object)this$changes).equals(other$changes)) {
            return false;
        }
        LocalDateTime this$timestamp = this.getTimestamp();
        LocalDateTime other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        Ownership this$ownership = this.getOwnership();
        Ownership other$ownership = other.getOwnership();
        return !(this$ownership == null ? other$ownership != null : !((Object)this$ownership).equals(other$ownership));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof VREvent;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Map<String, Long> $object = this.getObject();
        result = result * 59 + ($object == null ? 43 : ((Object)$object).hashCode());
        Map<String, Object> $changes = this.getChanges();
        result = result * 59 + ($changes == null ? 43 : ((Object)$changes).hashCode());
        LocalDateTime $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        Ownership $ownership = this.getOwnership();
        result = result * 59 + ($ownership == null ? 43 : ((Object)$ownership).hashCode());
        return result;
    }
}

