/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import lombok.NonNull;
import org.vrspace.server.obj.Client;
import org.vrspace.server.obj.VRObject;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.WRAPPER_OBJECT)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Welcome {
    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.WRAPPER_OBJECT)
    @NonNull
    private Client client;
    @NonNull
    private Set<VRObject> permanents;
    private LocalDateTime timestamp = LocalDateTime.now(ZoneId.of("UTC"));

    public Welcome(Client client, VRObject ... permanents) {
        this.client = client;
        this.permanents = new HashSet<VRObject>();
        VRObject[] vRObjectArray = permanents;
        int n = permanents.length;
        int n2 = 0;
        while (n2 < n) {
            VRObject o = vRObjectArray[n2];
            this.permanents.add(o);
            ++n2;
        }
    }

    @NonNull
    @Generated
    public Client getClient() {
        return this.client;
    }

    @NonNull
    @Generated
    public Set<VRObject> getPermanents() {
        return this.permanents;
    }

    @Generated
    public LocalDateTime getTimestamp() {
        return this.timestamp;
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.WRAPPER_OBJECT)
    @Generated
    public void setClient(@NonNull Client client) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        this.client = client;
    }

    @Generated
    public void setPermanents(@NonNull Set<VRObject> permanents) {
        if (permanents == null) {
            throw new NullPointerException("permanents is marked non-null but is null");
        }
        this.permanents = permanents;
    }

    @Generated
    public void setTimestamp(LocalDateTime timestamp) {
        this.timestamp = timestamp;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Welcome)) {
            return false;
        }
        Welcome other = (Welcome)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Client this$client = this.getClient();
        Client other$client = other.getClient();
        if (this$client == null ? other$client != null : !((Object)this$client).equals(other$client)) {
            return false;
        }
        Set<VRObject> this$permanents = this.getPermanents();
        Set<VRObject> other$permanents = other.getPermanents();
        if (this$permanents == null ? other$permanents != null : !((Object)this$permanents).equals(other$permanents)) {
            return false;
        }
        LocalDateTime this$timestamp = this.getTimestamp();
        LocalDateTime other$timestamp = other.getTimestamp();
        return !(this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Welcome;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Client $client = this.getClient();
        result = result * 59 + ($client == null ? 43 : ((Object)$client).hashCode());
        Set<VRObject> $permanents = this.getPermanents();
        result = result * 59 + ($permanents == null ? 43 : ((Object)$permanents).hashCode());
        LocalDateTime $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Welcome(client=" + String.valueOf(this.getClient()) + ", permanents=" + String.valueOf(this.getPermanents()) + ", timestamp=" + String.valueOf(this.getTimestamp()) + ")";
    }

    @Generated
    public Welcome() {
    }

    @Generated
    public Welcome(@NonNull Client client, @NonNull Set<VRObject> permanents) {
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (permanents == null) {
            throw new NullPointerException("permanents is marked non-null but is null");
        }
        this.client = client;
        this.permanents = permanents;
    }
}

