/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.obj;

import lombok.Generated;
import org.springframework.data.neo4j.core.schema.Node;
import org.vrspace.server.obj.Embedded;

@Node
public class Point
extends Embedded {
    private double x;
    private double y;
    private double z;

    public Point(Point position) {
        this(position.x, position.y, position.z);
    }

    public double getDistance(double x, double y, double z) {
        double dx = this.x - x;
        double dy = this.y - y;
        double dz = this.z - z;
        return Math.sqrt(dx * dx + dy * dy + dz * dz);
    }

    public boolean isInRange(Point p, double range) {
        return this.isInRange(p.x, p.y, p.z, range);
    }

    public boolean isInRange(double x, double y, double z, double range) {
        return this.x >= x - range && this.x <= x + range && this.y >= y - range && this.y <= y + range && this.z >= z - range && this.z <= z + range;
    }

    public Point copy(Point p) {
        this.x = p.x;
        this.y = p.y;
        this.z = p.z;
        return this;
    }

    public Point plus(double val) {
        this.x += val;
        this.y += val;
        this.z += val;
        return this;
    }

    public Point minus(double val) {
        this.x -= val;
        this.y -= val;
        this.z -= val;
        return this;
    }

    public boolean isEqual(Point p) {
        return p.x == this.x && p.y == this.y && p.z == this.z;
    }

    @Generated
    public double getX() {
        return this.x;
    }

    @Generated
    public double getY() {
        return this.y;
    }

    @Generated
    public double getZ() {
        return this.z;
    }

    @Generated
    public void setX(double x) {
        this.x = x;
    }

    @Generated
    public void setY(double y) {
        this.y = y;
    }

    @Generated
    public void setZ(double z) {
        this.z = z;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Point)) {
            return false;
        }
        Point other = (Point)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (Double.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Double.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        return Double.compare(this.getZ(), other.getZ()) == 0;
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Point;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        long $x = Double.doubleToLongBits(this.getX());
        result = result * 59 + (int)($x ^ $x >>> 32);
        long $y = Double.doubleToLongBits(this.getY());
        result = result * 59 + (int)($y ^ $y >>> 32);
        long $z = Double.doubleToLongBits(this.getZ());
        result = result * 59 + (int)($z ^ $z >>> 32);
        return result;
    }

    @Generated
    public Point() {
    }

    @Generated
    public Point(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    @Generated
    public String toString() {
        return "Point(x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ")";
    }
}

