/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.obj;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonMerge;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.Transient;
import org.springframework.data.neo4j.core.schema.Node;
import org.springframework.data.neo4j.core.schema.Relationship;
import org.vrspace.server.dto.VREvent;
import org.vrspace.server.obj.Animation;
import org.vrspace.server.obj.Entity;
import org.vrspace.server.obj.Point;
import org.vrspace.server.obj.Rotation;
import org.vrspace.server.obj.World;
import org.vrspace.server.types.ID;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.WRAPPER_OBJECT)
@Node
public class VRObject
extends Entity {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VRObject.class);
    private List<VRObject> children;
    @JsonIgnore
    private Long worldId;
    @Transient
    @JsonIgnore
    private transient World world;
    @JsonMerge
    @Relationship(type="HAS_POSITION", direction=Relationship.Direction.OUTGOING)
    private Point position;
    @JsonMerge
    private Rotation rotation;
    @JsonMerge
    @Relationship(type="HAS_SCALE", direction=Relationship.Direction.OUTGOING)
    private Point scale;
    private Boolean permanent;
    @Transient
    private transient Boolean temporary;
    private Boolean active;
    private String mesh;
    @JsonProperty
    private String script;
    @JsonMerge
    @Relationship(type="CURRENT_ANIMATION", direction=Relationship.Direction.OUTGOING)
    private Animation animation;
    @Transient
    private transient Map<String, Object> properties;
    @JsonIgnore
    @Transient
    private ConcurrentHashMap<ID, VRObject> listeners;

    public void setWorld(World world) {
        if (world == null) {
            this.setWorldId(null);
        } else {
            this.setWorldId(world.getId());
        }
        this.world = world;
    }

    public VRObject(World world) {
        this.setWorldId(world.getId());
    }

    public VRObject(Long id, VRObject ... vrObjects) {
        super(id);
        this.addChildren(vrObjects);
    }

    public VRObject(Long id, double x, double y, double z, VRObject ... vrObjects) {
        this(id, vrObjects);
        this.position = new Point(x, y, z);
    }

    public VRObject(double x, double y, double z) {
        this.setPosition(new Point(x, y, z));
    }

    public VRObject(World world, double x, double y, double z) {
        this(world);
        this.setPosition(new Point(x, y, z));
    }

    public void addChildren(VRObject ... vrObjects) {
        if (this.children == null) {
            this.children = new LinkedList<VRObject>();
        }
        for (VRObject obj : vrObjects) {
            if (this.equals(obj)) {
                throw new IllegalArgumentException("Can't have self as member");
            }
            this.children.add(obj);
        }
    }

    public boolean isPermanent() {
        return this.permanent != null && this.permanent != false;
    }

    public void addListener(VRObject obj) {
        if (this.listeners == null) {
            this.listeners = new ConcurrentHashMap();
        }
        this.listeners.put(new ID(obj), obj);
    }

    public void removeListener(VRObject obj) {
        if (this.listeners != null) {
            this.listeners.remove(new ID(obj));
        }
    }

    public void notifyListeners(VREvent event) {
        if (this.listeners != null) {
            for (VRObject listener : this.listeners.values()) {
                try {
                    listener.processEvent(event);
                }
                catch (Exception e) {
                    log.error("Error processing event " + event, (Throwable)e);
                }
            }
        }
    }

    public void processEvent(VREvent event) {
    }

    public VRObject active() {
        this.active = Boolean.TRUE;
        return this;
    }

    public VRObject passive() {
        this.active = Boolean.FALSE;
        return this;
    }

    public boolean isActive() {
        return this.active != null && this.active != false;
    }

    public boolean isTemporary() {
        return this.temporary != null && this.temporary != false;
    }

    @Generated
    public List<VRObject> getChildren() {
        return this.children;
    }

    @Generated
    public Long getWorldId() {
        return this.worldId;
    }

    @Generated
    public World getWorld() {
        return this.world;
    }

    @Generated
    public Point getPosition() {
        return this.position;
    }

    @Generated
    public Rotation getRotation() {
        return this.rotation;
    }

    @Generated
    public Point getScale() {
        return this.scale;
    }

    @Generated
    public Boolean getPermanent() {
        return this.permanent;
    }

    @Generated
    public Boolean getTemporary() {
        return this.temporary;
    }

    @Generated
    public Boolean getActive() {
        return this.active;
    }

    @Generated
    public String getMesh() {
        return this.mesh;
    }

    @Generated
    public String getScript() {
        return this.script;
    }

    @Generated
    public Animation getAnimation() {
        return this.animation;
    }

    @Generated
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Generated
    public ConcurrentHashMap<ID, VRObject> getListeners() {
        return this.listeners;
    }

    @Generated
    public void setChildren(List<VRObject> children) {
        this.children = children;
    }

    @JsonIgnore
    @Generated
    public void setWorldId(Long worldId) {
        this.worldId = worldId;
    }

    @Generated
    public void setPosition(Point position) {
        this.position = position;
    }

    @Generated
    public void setRotation(Rotation rotation) {
        this.rotation = rotation;
    }

    @Generated
    public void setScale(Point scale) {
        this.scale = scale;
    }

    @Generated
    public void setPermanent(Boolean permanent) {
        this.permanent = permanent;
    }

    @Generated
    public void setTemporary(Boolean temporary) {
        this.temporary = temporary;
    }

    @Generated
    public void setActive(Boolean active) {
        this.active = active;
    }

    @Generated
    public void setMesh(String mesh) {
        this.mesh = mesh;
    }

    @JsonProperty
    @Generated
    public void setScript(String script) {
        this.script = script;
    }

    @Generated
    public void setAnimation(Animation animation) {
        this.animation = animation;
    }

    @Generated
    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    @JsonIgnore
    @Generated
    public void setListeners(ConcurrentHashMap<ID, VRObject> listeners) {
        this.listeners = listeners;
    }

    @Generated
    public VRObject() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VRObject)) {
            return false;
        }
        VRObject other = (VRObject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof VRObject;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "VRObject(super=" + super.toString() + ")";
    }
}

