/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.api;

import java.util.List;
import java.util.UUID;
import javax.servlet.http.HttpSession;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.vrspace.server.api.ApiBase;
import org.vrspace.server.api.ApiException;
import org.vrspace.server.core.ClientFactory;
import org.vrspace.server.core.VRObjectRepository;
import org.vrspace.server.core.WorldManager;
import org.vrspace.server.dto.WorldStatus;
import org.vrspace.server.obj.Client;
import org.vrspace.server.obj.World;

@RestController
@RequestMapping(value={"/vrspace/api/worlds"})
public class WorldController
extends ApiBase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorldController.class);
    public static final String PATH = "/vrspace/api/worlds";
    @Autowired
    private VRObjectRepository db;
    @Autowired
    private ClientFactory clientFactory;
    @Autowired
    private WorldManager manager;

    @GetMapping(value={"/list"})
    public List<World> list() {
        List<World> worlds = this.db.listWorlds();
        log.debug("Worlds: " + worlds);
        return worlds;
    }

    @GetMapping(value={"/users"})
    public List<WorldStatus> users() {
        List<WorldStatus> stats = this.db.countUsers();
        log.debug("Stats: " + stats);
        return stats;
    }

    @PostMapping(value={"/create"})
    public ResponseEntity<String> createWorld(HttpSession session, @RequestParam(required=true) String worldName, String templateWorldName, boolean isPublic, boolean isTemporary) {
        String userName = WorldController.currentUserName(session, this.clientFactory);
        if (userName == null) {
            throw new SecurityException("User must be logged in");
        }
        Client user = this.manager.getClientByName(userName);
        if (user == null) {
            throw new SecurityException("User " + userName + " must be logged in");
        }
        if (worldName == null) {
            throw new ApiException("World name must be specified");
        }
        World world = this.db.getWorldByName(worldName);
        if (world == null) {
            world = new World();
            if (templateWorldName != null) {
                // empty if block
            }
            world.setName(worldName);
            world.setOwner(user);
            world.setDefaultWorld(false);
            world.setPublicWorld(isPublic);
            world.setTemporaryWorld(isTemporary);
            if (!isPublic) {
                world.setToken(UUID.randomUUID().toString());
            }
            world = this.manager.saveWorld(world);
            log.info("World " + worldName + " created by user " + userName + " token: " + world.getToken());
            return new ResponseEntity((Object)world.getToken(), HttpStatus.CREATED);
        }
        if (!user.equals((world = (World)this.db.get(World.class, world.getId())).getOwner())) {
            throw new SecurityException("User " + userName + " does not own exiting world " + worldName);
        }
        world.setPublicWorld(isPublic);
        world.setTemporaryWorld(isTemporary);
        if (isPublic) {
            world.setToken(null);
        } else {
            world.setToken(UUID.randomUUID().toString());
        }
        log.info("World " + worldName + " updated by user " + userName + " token: " + world.getToken());
        return new ResponseEntity((Object)world.getToken(), HttpStatus.OK);
    }
}

