/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.config;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.web.SecurityFilterChain;

@Configuration
@ConditionalOnProperty(value={"org.vrspace.oauth2.enabled"})
@EnableWebSecurity
public class WebSecurityConfig {
    public static final String ENDPOINT = "/vrspace/api/oauth2";

    @Bean
    SecurityFilterChain filterChain(HttpSecurity httpSecurity) throws Exception {
        return (SecurityFilterChain)httpSecurity.csrf(csrf -> csrf.disable()).authorizeRequests(requests -> ((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)requests.antMatchers(new String[]{"/vrspace/api/oauth2/login**"})).authenticated()).oauth2Login(login -> login.loginPage("/vrspace/api/oauth2/provider").authorizationEndpoint().baseUri("/vrspace/api/oauth2/authorization")).build();
    }
}

