/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.obj;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.Transient;
import org.springframework.data.neo4j.core.schema.Node;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.handler.ConcurrentWebSocketSessionDecorator;
import org.vrspace.server.core.Scene;
import org.vrspace.server.core.WorldManager;
import org.vrspace.server.core.WriteBack;
import org.vrspace.server.dto.SceneProperties;
import org.vrspace.server.dto.VREvent;
import org.vrspace.server.dto.Welcome;
import org.vrspace.server.obj.VRObject;
import org.vrspace.server.types.Owned;
import org.vrspace.server.types.Private;

@Node
@Owned
public class Client
extends VRObject {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Client.class);
    private String name;
    @Transient
    private transient Double userHeight;
    @Private
    @Transient
    private transient SceneProperties sceneProperties;
    @JsonIgnore
    @Transient
    private transient Scene scene;
    @Private
    @JsonIgnore
    private String identity;
    @Private
    @Transient
    private transient Map<String, String> tokens = new HashMap<String, String>();
    @JsonIgnore
    @Transient
    private transient WriteBack writeBack;
    @JsonIgnore
    @Transient
    private transient ConcurrentWebSocketSessionDecorator session;
    @JsonIgnore
    @Transient
    private transient ObjectMapper mapper;
    @JsonIgnore
    @Transient
    private transient ObjectMapper privateMapper;
    @JsonIgnore
    @Transient
    private transient boolean guest;

    public Client() {
        this.setActive(true);
    }

    public Client(Long id) {
        this();
        this.setId(id);
    }

    public Client(String name) {
        this();
        this.name = name;
    }

    public Client(ConcurrentWebSocketSessionDecorator session) {
        this();
        this.session = session;
    }

    @Override
    public void processEvent(VREvent event) {
        if (!event.getSource().isActive()) {
            event.getSource().removeListener(this);
        } else if (event.getPayload() == null) {
            this.sendMessage(event);
        } else {
            this.send(event.getPayload());
        }
    }

    private void send(String json) {
        log.debug(this.getObjectId() + " Received " + json);
        if (this.session != null && this.session.isOpen()) {
            try {
                this.session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)json));
            }
            catch (IOException e) {
                log.warn("Can't send message " + json + " to " + this.getObjectId() + ": " + e);
            }
            catch (IllegalStateException e) {
                log.warn("Can't send message " + json + " to " + this.getObjectId() + ": " + e);
            }
        } else {
            log.debug("Session closed: " + this.session + ", message ignored: " + json);
        }
    }

    public void sendMessage(Object obj) {
        try {
            if (this.equals(obj) || obj instanceof Welcome) {
                this.send(this.privateMapper.writeValueAsString(obj));
            } else {
                this.send(this.mapper.writeValueAsString(obj));
            }
        }
        catch (Exception e) {
            log.error("Can't send message " + obj, (Throwable)e);
        }
    }

    public String getToken(String serviceId) {
        return this.tokens.get(serviceId);
    }

    public void setToken(String serviceId, String value) {
        if (value == null) {
            this.clearToken(serviceId);
        }
        this.tokens.put(serviceId, value);
    }

    public String clearToken(String serviceId) {
        return this.tokens.remove(serviceId);
    }

    public void createScene(WorldManager wm) {
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Double getUserHeight() {
        return this.userHeight;
    }

    @Generated
    public SceneProperties getSceneProperties() {
        return this.sceneProperties;
    }

    @Generated
    public Scene getScene() {
        return this.scene;
    }

    @Generated
    public String getIdentity() {
        return this.identity;
    }

    @Generated
    public Map<String, String> getTokens() {
        return this.tokens;
    }

    @Generated
    public WriteBack getWriteBack() {
        return this.writeBack;
    }

    @Generated
    public ConcurrentWebSocketSessionDecorator getSession() {
        return this.session;
    }

    @Generated
    public ObjectMapper getMapper() {
        return this.mapper;
    }

    @Generated
    public ObjectMapper getPrivateMapper() {
        return this.privateMapper;
    }

    @Generated
    public boolean isGuest() {
        return this.guest;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setUserHeight(Double userHeight) {
        this.userHeight = userHeight;
    }

    @Generated
    public void setSceneProperties(SceneProperties sceneProperties) {
        this.sceneProperties = sceneProperties;
    }

    @JsonIgnore
    @Generated
    public void setScene(Scene scene) {
        this.scene = scene;
    }

    @JsonIgnore
    @Generated
    public void setIdentity(String identity) {
        this.identity = identity;
    }

    @Generated
    public void setTokens(Map<String, String> tokens) {
        this.tokens = tokens;
    }

    @JsonIgnore
    @Generated
    public void setWriteBack(WriteBack writeBack) {
        this.writeBack = writeBack;
    }

    @JsonIgnore
    @Generated
    public void setSession(ConcurrentWebSocketSessionDecorator session) {
        this.session = session;
    }

    @JsonIgnore
    @Generated
    public void setMapper(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    @JsonIgnore
    @Generated
    public void setPrivateMapper(ObjectMapper privateMapper) {
        this.privateMapper = privateMapper;
    }

    @JsonIgnore
    @Generated
    public void setGuest(boolean guest) {
        this.guest = guest;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Client)) {
            return false;
        }
        Client other = (Client)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Client;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "Client(super=" + super.toString() + ", name=" + this.getName() + ", guest=" + this.isGuest() + ")";
    }
}

