/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.config;

import jakarta.annotation.PreDestroy;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import lombok.Generated;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.BoltConnector;
import org.neo4j.configuration.connectors.HttpConnector;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.api.DatabaseManagementServiceBuilder;
import org.neo4j.graphdb.GraphDatabaseService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.FileSystemUtils;

@Configuration
public class NeoConfig {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NeoConfig.class);
    @Value(value="${org.vrspace.db.embedded:#{true}}")
    private boolean embedded;
    @Value(value="${org.vrspace.db:file:./vrspace.db}")
    private String dbPath;
    @Value(value="${org.vrspace.db.cleanup:false}")
    private boolean cleanup;
    @Value(value="${spring.neo4j.uri:bolt://localhost}")
    private String neoUri;
    private GraphDatabaseService graphDb;
    private DatabaseManagementService managementService;
    private File dbDir;

    @Bean(value={"database"})
    GraphDatabaseService config() throws URISyntaxException, IOException {
        String path = this.dbPath;
        if (this.embedded) {
            log.info("Configured database uri: " + path);
            path = path.replace('\\', '/');
            URI uri = new URI(path);
            this.dbDir = new File(uri.getSchemeSpecificPart()).getCanonicalFile().getAbsoluteFile();
            log.info("Absolute database path: " + this.dbDir);
            this.neoStart(this.dbDir.toPath());
            return this.graphDb;
        }
        log.info("Using external database uri: " + this.neoUri);
        return null;
    }

    private void neoStart(Path dbDir) {
        this.cleanup();
        int port = 7687;
        int pos = this.neoUri.indexOf(":", this.neoUri.indexOf("://") + 1);
        if (pos > 0) {
            String sPort = this.neoUri.substring(pos + 1);
            try {
                port = Integer.valueOf(sPort);
            }
            catch (Exception e) {
                log.error("Can't parse database port from " + this.neoUri + " - " + e);
            }
        }
        log.info("Starting database on " + this.neoUri);
        this.managementService = new DatabaseManagementServiceBuilder(dbDir).setConfig(GraphDatabaseSettings.allow_upgrade, (Object)true).setConfig(BoltConnector.enabled, (Object)this.neoUri.startsWith("bolt:")).setConfig(BoltConnector.listen_address, (Object)new SocketAddress("localhost", port)).setConfig(HttpConnector.enabled, (Object)this.neoUri.startsWith("http:")).build();
        this.graphDb = this.managementService.database("neo4j");
        this.graphDb.executeTransactionally("CREATE CONSTRAINT worldName IF NOT EXISTS ON (w:World) ASSERT w.name IS UNIQUE");
        this.graphDb.executeTransactionally("CREATE CONSTRAINT clientName IF NOT EXISTS ON (c:Client) ASSERT c.name IS UNIQUE");
        this.graphDb.executeTransactionally("CREATE INDEX clientWorld IF NOT EXISTS FOR (c:Client) ON (c.worldId)");
        this.graphDb.executeTransactionally("CREATE INDEX pointCoord IF NOT EXISTS FOR (p:Point) ON (p.x, p.y, p.z)");
        this.graphDb.executeTransactionally("CREATE INDEX ownership IF NOT EXISTS FOR (o:Ownership) ON (o.owner,o.owned)");
    }

    @PreDestroy
    public void stop() {
        if (this.managementService != null) {
            log.info("Database shutting down...");
            this.managementService.shutdown();
            log.info("Database shutting down complete");
            this.cleanup();
        }
    }

    private void cleanup() {
        if (this.cleanup && this.dbDir != null) {
            log.info("Deleting database directory " + this.dbDir);
            FileSystemUtils.deleteRecursively((File)this.dbDir);
        }
    }
}

