/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.config;

import io.github.bonigarcia.wdm.WebDriverManager;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import jakarta.servlet.annotation.WebListener;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionListener;
import java.time.Duration;
import java.util.Collections;
import java.util.EventListener;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.interactions.InputSource;
import org.openqa.selenium.interactions.PointerInput;
import org.openqa.selenium.interactions.Sequence;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@WebListener
public class SeleniumConfig
implements HttpSessionListener,
ServletContextListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SeleniumConfig.class);
    private static ConcurrentHashMap<WebSession, WebSession> sessions = new ConcurrentHashMap();

    public void sessionDestroyed(HttpSessionEvent se) {
        log.debug("Session destroyed");
        WebSession session = (WebSession)se.getSession().getAttribute("webDriver");
        if (session != null) {
            session.quit();
        }
    }

    @Bean
    @ConditionalOnProperty(prefix="org.vrspace.server", name={"selenium-enabled"}, havingValue="true")
    WebSessionFactory factory() {
        log.warn("Enabling remote browsing - security risk");
        WebDriverManager.firefoxdriver().setup();
        return new WebSessionFactory();
    }

    @Bean
    ServletListenerRegistrationBean<HttpSessionListener> sessionListener() {
        log.info("Servlet context initialized, installing web garbage collector");
        return new ServletListenerRegistrationBean((EventListener)((Object)this));
    }

    public void contextDestroyed(ServletContextEvent sce) {
        log.debug("ServletContext destroyed, cleaning up " + sessions.size() + " web sessions");
        ((ConcurrentHashMap.KeySetView)sessions.keySet()).forEach(e -> e.quit());
    }

    public class WebSession {
        public static final String KEY = "webDriver";
        public WebDriver webDriver;
        public String currentTab;
        public Map<String, WindowStatus> tabs = new ConcurrentHashMap<String, WindowStatus>();

        public WebSession() {
            log.debug("Creating new firefox instance");
            FirefoxOptions options = new FirefoxOptions();
            options.addArguments(new String[]{"-headless"});
            this.webDriver = new FirefoxDriver(options);
            int offset = 85;
            this.webDriver.manage().window().setSize(new Dimension(2048, 1024 + offset));
            this.currentTab = this.webDriver.getWindowHandle();
            this.select(this.currentTab);
            sessions.put(this, this);
        }

        public int close() {
            this.tabs.remove(this.currentTab);
            this.webDriver.close();
            if (this.tabs.size() > 0) {
                this.switchTab();
            }
            return this.tabs.size();
        }

        public void quit() {
            log.debug("Destroying a web driver");
            sessions.remove(this);
            this.webDriver.quit();
        }

        public WindowStatus status() {
            return this.tabs.get(this.currentTab);
        }

        public void switchTab() {
            String[] handles = this.webDriver.getWindowHandles().toArray(new String[0]);
            String tabHandle = handles[handles.length - 1];
            this.select(tabHandle);
            this.webDriver.switchTo().window(tabHandle);
        }

        public void select(String windowHandle) {
            WindowStatus status = this.tabs.get(windowHandle);
            if (status == null) {
                this.tabs.put(windowHandle, new WindowStatus());
            }
            this.currentTab = windowHandle;
        }

        public void action() {
            WindowStatus status = this.tabs.get(this.currentTab);
            status.increaseDepth();
        }

        public void back() {
            WindowStatus status = this.tabs.get(this.currentTab);
            status.decreaseDepth();
        }

        public int activeTabs() {
            return this.webDriver.getWindowHandles().size();
        }

        public Integer size() {
            return this.tabs.size();
        }

        public WebElement click(int x, int y) {
            JavascriptExecutor jse = (JavascriptExecutor)this.webDriver;
            WebElement clickedElement = (WebElement)jse.executeScript("return document.elementFromPoint(arguments[0], arguments[1])", new Object[]{x, y});
            WindowStatus status = this.tabs.get(this.currentTab);
            status.x = x;
            status.y = y;
            PointerInput mouse = new PointerInput(PointerInput.Kind.MOUSE, "default mouse");
            Sequence actions = new Sequence((InputSource)mouse, 0).addAction(mouse.createPointerMove(Duration.ZERO, PointerInput.Origin.viewport(), x, y)).addAction(mouse.createPointerDown(PointerInput.MouseButton.LEFT.asArg())).addAction(mouse.createPointerUp(PointerInput.MouseButton.LEFT.asArg()));
            ((RemoteWebDriver)this.webDriver).perform(Collections.singletonList(actions));
            return clickedElement;
        }
    }

    public class WebSessionFactory {
        public WebSession newSession() {
            WebSession ret = new WebSession();
            return ret;
        }
    }

    public class WindowStatus {
        public Integer depth = 0;
        public Integer maxDepth = 0;
        public Integer x = 0;
        public Integer y = 0;

        public void increaseDepth() {
            Integer n = this.depth;
            this.depth = this.depth + 1;
            if (this.depth > this.maxDepth) {
                this.maxDepth = this.depth;
            }
        }

        public void decreaseDepth() {
            if (this.depth > 0) {
                Integer n = this.depth;
                this.depth = this.depth - 1;
            }
        }
    }
}

