/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.obj;

import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.Transient;
import org.springframework.data.neo4j.core.schema.Node;
import org.vrspace.server.core.WorldManager;
import org.vrspace.server.obj.Client;
import org.vrspace.server.obj.Point;
import org.vrspace.server.obj.RemoteServer;
import org.vrspace.server.obj.Rotation;
import org.vrspace.server.obj.World;

@Node
public class ServerWorld
extends World {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServerWorld.class);
    private String url;
    private String portalMesh;
    private String portalThumbnail;
    private String portalScript;
    @Transient
    private transient ConcurrentHashMap<Long, RemoteServer> currentServers = new ConcurrentHashMap();
    @Transient
    private AtomicInteger serverCount = new AtomicInteger();
    @Transient
    private transient double dl = 10.0;
    @Transient
    private transient double k = 2.0;

    @Override
    public synchronized boolean enter(Client client, WorldManager wm) {
        if (client instanceof RemoteServer) {
            RemoteServer server = (RemoteServer)client;
            server.setOrder(this.serverCount.getAndIncrement());
            this.currentServers.put(server.getId(), server);
            log.debug("Connecting portal " + server.getOrder() + "/" + this.serverCount + " size " + this.currentServers.size());
            server.setMesh(this.getPortalMesh());
            server.setScript(this.getPortalScript());
            if (server.getUrl() == null) {
                server.setUrl(this.getUrl());
            }
            if (server.getThumbnail() == null) {
                server.setThumbnail(this.getPortalThumbnail());
            }
            double angle = 0.0;
            RemoteServer[] servers = this.currentServers.values().toArray(new RemoteServer[this.currentServers.size()]);
            Arrays.sort(servers, (o1, o2) -> o1.getOrder() - o2.getOrder());
            for (int i = 0; i < servers.length; ++i) {
                RemoteServer portal = servers[i];
                portal.setOrder(i);
                double da = Math.sqrt(this.dl * this.dl / (this.k * this.k * (1.0 + angle * angle)));
                this.setPortalPosition(portal, angle += da);
            }
            wm.save(server);
            log.debug("New portal " + server.getOrder() + "/" + this.serverCount);
        }
        return true;
    }

    private void setPortalPosition(RemoteServer portal, double angle) {
        double r = this.k * angle;
        double x = Math.cos(angle) * r;
        double z = Math.sin(angle) * r;
        portal.setPosition(new Point(x, 0.0, z));
        Rotation rot = new Rotation(0.0, angle, 0.0);
        portal.setRotation(rot);
    }

    @Override
    public synchronized void exit(Client client, WorldManager wm) {
        if (client instanceof RemoteServer) {
            RemoteServer server = (RemoteServer)client;
            this.serverCount.decrementAndGet();
            this.currentServers.remove(server.getId());
            log.debug("Removed portal " + server.getOrder() + "/" + this.serverCount + " size " + this.currentServers.size());
        }
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getPortalMesh() {
        return this.portalMesh;
    }

    @Generated
    public String getPortalThumbnail() {
        return this.portalThumbnail;
    }

    @Generated
    public String getPortalScript() {
        return this.portalScript;
    }

    @Generated
    public ConcurrentHashMap<Long, RemoteServer> getCurrentServers() {
        return this.currentServers;
    }

    @Generated
    public AtomicInteger getServerCount() {
        return this.serverCount;
    }

    @Generated
    public double getDl() {
        return this.dl;
    }

    @Generated
    public double getK() {
        return this.k;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setPortalMesh(String portalMesh) {
        this.portalMesh = portalMesh;
    }

    @Generated
    public void setPortalThumbnail(String portalThumbnail) {
        this.portalThumbnail = portalThumbnail;
    }

    @Generated
    public void setPortalScript(String portalScript) {
        this.portalScript = portalScript;
    }

    @Generated
    public void setCurrentServers(ConcurrentHashMap<Long, RemoteServer> currentServers) {
        this.currentServers = currentServers;
    }

    @Generated
    public void setServerCount(AtomicInteger serverCount) {
        this.serverCount = serverCount;
    }

    @Generated
    public void setDl(double dl) {
        this.dl = dl;
    }

    @Generated
    public void setK(double k) {
        this.k = k;
    }

    @Generated
    public ServerWorld() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerWorld)) {
            return false;
        }
        ServerWorld other = (ServerWorld)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ServerWorld;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "ServerWorld(super=" + super.toString() + ", url=" + this.getUrl() + ", portalMesh=" + this.getPortalMesh() + ", portalThumbnail=" + this.getPortalThumbnail() + ", portalScript=" + this.getPortalScript() + ", currentServers=" + this.getCurrentServers() + ", serverCount=" + this.getServerCount() + ", dl=" + this.getDl() + ", k=" + this.getK() + ")";
    }
}

