/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.api;

import jakarta.servlet.http.HttpSession;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;
import org.vrspace.server.api.ClientControllerBase;
import org.vrspace.server.obj.Client;
import org.vrspace.server.obj.Point;
import org.vrspace.server.obj.VRObject;
import org.vrspace.server.types.ID;

@RestController
@RequestMapping(value={"/vrspace/api/metakraft"})
@ConditionalOnProperty(value={"metakraft.key"})
public class MetakraftController
extends ClientControllerBase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetakraftController.class);
    public static final String PATH = "/vrspace/api/metakraft";
    @Value(value="${metakraft.key}")
    private String metakraftKey;
    @Value(value="${metakraft.quality:normal}")
    private String quality;

    private HttpHeaders headers() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        headers.set("x-api-key", this.metakraftKey);
        return headers;
    }

    private HttpEntity<MultiValueMap<String, String>> request(String modelId) {
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"id", (Object)modelId);
        HttpEntity request = new HttpEntity((Object)map, (MultiValueMap)this.headers());
        return request;
    }

    @PostMapping(value={"/generate"})
    public MetakraftModelInfo generate(HttpSession session, Double x, Double y, Double z, String prompt) {
        Client client = this.findClient(session);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"prompt", (Object)prompt);
        map.add((Object)"quality", (Object)this.quality);
        HttpEntity request = new HttpEntity((Object)map, (MultiValueMap)this.headers());
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity response = restTemplate.postForEntity("https://api.metakraft.ai/v1/3d-model-gen/generate", (Object)request, MetakraftResponse.class, new Object[0]);
        log.debug("Response: " + response);
        MetakraftModelInfo modelInfo = ((MetakraftResponse)response.getBody()).getData();
        VRObject obj = new VRObject();
        obj.setMesh(modelInfo.getGlbUrl());
        obj.setActive(true);
        obj.setProperties(Map.of("clientId", client.getId(), "metakraftId", modelInfo.getId(), "canRig", false, "isAdvanced", false));
        if (x != null & y != null & z != null) {
            Point pos = new Point(x, y, z);
            obj.setPosition(pos);
        }
        this.worldManager.add(client, obj);
        client.getScene().publish(obj);
        return modelInfo;
    }

    @PostMapping(value={"/refine"})
    public void refine() {
    }

    @PostMapping(value={"/style"})
    public void style(HttpSession session, Long id, String style) {
        Client client = this.findClient(session);
        VRObject obj = this.worldManager.get(new ID("VRObject", id));
        String modelId = (String)obj.getProperties().get("metakraftId");
        HttpEntity<MultiValueMap<String, String>> request = this.request(modelId);
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity response = restTemplate.exchange("https://api.metakraft.ai/v1/3d-model-gen/stylize?id=" + modelId, HttpMethod.GET, request, OtherResponse.class, new Object[0]);
        log.debug("Response: " + response);
        String url = ((OtherResponse)response.getBody()).getData();
        obj.setMesh(url);
    }

    public boolean isRiggable(String modelId) {
        HttpEntity<MultiValueMap<String, String>> request = this.request(modelId);
        try {
            RestTemplate restTemplate = new RestTemplate();
            ResponseEntity response = restTemplate.exchange("https://api.metakraft.ai/v1/3d-model-gen/pre-rig?id=" + modelId, HttpMethod.GET, request, OtherResponse.class, new Object[0]);
            log.debug("Response: " + response);
            return true;
        }
        catch (Exception e) {
            log.error("IsRigged call failed - " + e);
            return false;
        }
    }

    public void rig() {
    }

    public void animate() {
    }

    public static class MetakraftResponse {
        private boolean success;
        private MetakraftModelInfo data;

        @Generated
        public MetakraftResponse() {
        }

        @Generated
        public boolean isSuccess() {
            return this.success;
        }

        @Generated
        public MetakraftModelInfo getData() {
            return this.data;
        }

        @Generated
        public void setSuccess(boolean success) {
            this.success = success;
        }

        @Generated
        public void setData(MetakraftModelInfo data) {
            this.data = data;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MetakraftResponse)) {
                return false;
            }
            MetakraftResponse other = (MetakraftResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isSuccess() != other.isSuccess()) {
                return false;
            }
            MetakraftModelInfo this$data = this.getData();
            MetakraftModelInfo other$data = other.getData();
            return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof MetakraftResponse;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSuccess() ? 79 : 97);
            MetakraftModelInfo $data = this.getData();
            result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MetakraftController.MetakraftResponse(success=" + this.isSuccess() + ", data=" + this.getData() + ")";
        }
    }

    public static class MetakraftModelInfo {
        private String glbUrl;
        private String image;
        private String id;

        @Generated
        public MetakraftModelInfo() {
        }

        @Generated
        public String getGlbUrl() {
            return this.glbUrl;
        }

        @Generated
        public String getImage() {
            return this.image;
        }

        @Generated
        public String getId() {
            return this.id;
        }

        @Generated
        public void setGlbUrl(String glbUrl) {
            this.glbUrl = glbUrl;
        }

        @Generated
        public void setImage(String image) {
            this.image = image;
        }

        @Generated
        public void setId(String id) {
            this.id = id;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MetakraftModelInfo)) {
                return false;
            }
            MetakraftModelInfo other = (MetakraftModelInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$glbUrl = this.getGlbUrl();
            String other$glbUrl = other.getGlbUrl();
            if (this$glbUrl == null ? other$glbUrl != null : !this$glbUrl.equals(other$glbUrl)) {
                return false;
            }
            String this$image = this.getImage();
            String other$image = other.getImage();
            if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            return !(this$id == null ? other$id != null : !this$id.equals(other$id));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof MetakraftModelInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $glbUrl = this.getGlbUrl();
            result = result * 59 + ($glbUrl == null ? 43 : $glbUrl.hashCode());
            String $image = this.getImage();
            result = result * 59 + ($image == null ? 43 : $image.hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MetakraftController.MetakraftModelInfo(glbUrl=" + this.getGlbUrl() + ", image=" + this.getImage() + ", id=" + this.getId() + ")";
        }
    }

    public static class OtherResponse {
        private boolean success;
        private String data;

        @Generated
        public OtherResponse() {
        }

        @Generated
        public boolean isSuccess() {
            return this.success;
        }

        @Generated
        public String getData() {
            return this.data;
        }

        @Generated
        public void setSuccess(boolean success) {
            this.success = success;
        }

        @Generated
        public void setData(String data) {
            this.data = data;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OtherResponse)) {
                return false;
            }
            OtherResponse other = (OtherResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isSuccess() != other.isSuccess()) {
                return false;
            }
            String this$data = this.getData();
            String other$data = other.getData();
            return !(this$data == null ? other$data != null : !this$data.equals(other$data));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof OtherResponse;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isSuccess() ? 79 : 97);
            String $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "MetakraftController.OtherResponse(success=" + this.isSuccess() + ", data=" + this.getData() + ")";
        }
    }
}

