/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.core;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class ClassUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClassUtil.class);

    public static String projectHomeDirectory() {
        String ret = null;
        String className = ClassUtil.class.getName().replace(".", "/") + ".class";
        URL classUrl = ClassUtil.class.getClassLoader().getResource(className);
        String path = classUrl.getPath();
        int start = path.indexOf("file:");
        start = start < 0 ? 0 : (start += "file:".length());
        int end = path.lastIndexOf("/server/target");
        if (end > 0) {
            ret = path.substring(start, end);
        } else {
            end = path.lastIndexOf("/server-");
            if (end > 0) {
                ret = path.substring(start, end);
                File serverDir = new File(ret);
                try {
                    ret = serverDir.getParentFile().getCanonicalPath();
                }
                catch (IOException e) {
                    log.error("Can't deduce parent dir of " + path + " - using current dir", (Throwable)e);
                    ret = Paths.get(".", new String[0]).toAbsolutePath().normalize().toString();
                }
            }
        }
        log.debug("VRSpace home directory: " + ret + " deduced from location of " + className + ": " + classUrl);
        return ret;
    }

    public static List<Class<?>> findSubclasses(Class<?> superClass) {
        ArrayList ret = new ArrayList();
        Package pkg = superClass.getPackage();
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        provider.addIncludeFilter((TypeFilter)new AssignableTypeFilter(superClass));
        Set components = provider.findCandidateComponents(pkg.getName());
        for (BeanDefinition component : components) {
            try {
                Class<?> c = Class.forName(component.getBeanClassName());
                if (c == superClass || !superClass.isAssignableFrom(c)) continue;
                ret.add(c);
            }
            catch (ClassNotFoundException e) {
                log.error("Error scanning subclasses of " + superClass.getName(), (Throwable)e);
            }
        }
        return ret;
    }
}

