/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vrspace.server.dto.VREvent;
import org.vrspace.server.obj.VRObject;
import org.vrspace.server.types.Owned;
import org.vrspace.server.types.Private;

public class Dispatcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Dispatcher.class);
    private ObjectMapper objectMapper;
    private Map<Class<?>, Set<String>> privateFields = new ConcurrentHashMap();
    private Map<Class<?>, Set<String>> ownedFields = new ConcurrentHashMap();

    public Dispatcher(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    protected void dispatch(VREvent event) throws JsonProcessingException, IOException {
        if (event.getChanges().size() == 0) {
            throw new IllegalArgumentException("Event must contain changes");
        }
        if (event.getChanges().containsKey("id")) {
            throw new IllegalArgumentException("Object id cannot change");
        }
        if (event.getSource() == null) {
            throw new IllegalArgumentException("Source of event is null");
        }
        VRObject source = event.getSource();
        if (!event.isOwner()) {
            if (source.getClass().isAnnotationPresent(Owned.class)) {
                throw new SecurityException("Cannot change owned object'");
            }
            this.declaredFields(source.getClass(), Owned.class, this.ownedFields).forEach(key -> {
                if (event.getChanges().containsKey(key)) {
                    throw new SecurityException("Cannot change owned field '" + key + "'");
                }
            });
        }
        String payload = event.getPayload();
        String changes = null;
        if (payload == null) {
            changes = this.objectMapper.writeValueAsString(event.getChanges());
            event.setPayload(this.objectMapper.writeValueAsString((Object)event));
        } else {
            try {
                changes = payload.substring(payload.indexOf("{", payload.indexOf("}")), payload.length() - 1);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid event payload: " + payload, e);
            }
            log.debug("Processing changes from " + event.getClient().getObjectId() + " on " + event.getSource().getObjectId() + ":" + changes);
        }
        ObjectReader reader = this.objectMapper.readerForUpdating((Object)source);
        reader.readValue(changes);
        this.declaredFields(source.getClass(), Private.class, this.privateFields).forEach(event.getChanges()::remove);
        if (event.getChanges().size() > 0) {
            source.notifyListeners(event);
        }
    }

    private Set<String> declaredFields(Class<?> cls, Class<? extends Annotation> annotation, Map<Class<?>, Set<String>> fieldCache) {
        Set<String> ret = fieldCache.get(cls);
        if (ret == null) {
            ret = new LinkedHashSet<String>(1);
            if (cls.getSuperclass() != null) {
                ret = this.declaredFields(cls.getSuperclass(), annotation, fieldCache);
            }
            for (Field f : cls.getDeclaredFields()) {
                if (f.getAnnotation(annotation) == null) continue;
                ret.add(f.getName());
            }
            fieldCache.put(cls, ret);
        }
        return ret;
    }
}

