/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.net.URL;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;
import org.vrspace.server.api.ApiBase;
import org.vrspace.server.core.ClassUtil;
import org.vrspace.server.core.FileUtil;
import org.vrspace.server.core.VRObjectRepository;
import org.vrspace.server.obj.ContentCategory;
import org.vrspace.server.obj.GltfModel;

@RestController
@RequestMapping(value={"/vrspace/api/sketchfab"})
public class SketchfabController
extends ApiBase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SketchfabController.class);
    public static final String PATH = "/vrspace/api/sketchfab";
    @Autowired
    ObjectMapper objectMapper;
    @Autowired
    VRObjectRepository db;
    private final String loginUrl = "https://sketchfab.com/oauth2/token/";
    @Value(value="${sketchfab.clientId:none}")
    private String clientId;
    @Value(value="${sketchfab.clientSecret:none}")
    private String clientSecret;
    @Value(value="${sketchfab.redirectUri:none}")
    private String redirectUri;
    private String token;
    private String referrer;

    @GetMapping(value={"/login"})
    public LoginResponse login(HttpServletRequest request) {
        this.referrer = request.getHeader("Referer");
        LoginResponse ret = new LoginResponse("https://sketchfab.com/oauth2/authorize/?response_type=code&client_id=" + this.clientId + "&redirect_uri=" + this.redirectUri);
        return ret;
    }

    @GetMapping(value={"/oauth2"})
    public ResponseEntity<String> callback(String code) {
        log.info("Login code " + code);
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"grant_type", (Object)"authorization_code");
        map.add((Object)"code", (Object)code);
        map.add((Object)"client_id", (Object)this.clientId);
        map.add((Object)"client_secret", (Object)this.clientSecret);
        map.add((Object)"redirect_uri", (Object)this.redirectUri);
        HttpEntity<MultiValueMap<String, String>> request = this.authRequest((MultiValueMap<String, String>)map);
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity response = restTemplate.postForEntity("https://sketchfab.com/oauth2/token/", request, AuthResponse.class, new Object[0]);
        log.debug("Login response: " + response);
        AuthResponse auth = (AuthResponse)response.getBody();
        if (auth.getExpires_in() < 604800) {
            auth = this.refresh(auth.getRefresh_token());
        }
        this.token = auth.getAccess_token();
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.FOUND).header("Location", new String[]{this.referrer})).body((Object)("Redirecting to " + this.referrer));
    }

    private HttpEntity<MultiValueMap<String, String>> authRequest(MultiValueMap<String, String> fields) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        HttpEntity request = new HttpEntity(fields, (MultiValueMap)headers);
        return request;
    }

    private AuthResponse refresh(String refreshToken) {
        LinkedMultiValueMap map = new LinkedMultiValueMap();
        map.add((Object)"grant_type", (Object)"refresh_token");
        map.add((Object)"client_id", (Object)this.clientId);
        map.add((Object)"client_secret", (Object)this.clientSecret);
        map.add((Object)"refresh_token", (Object)refreshToken);
        RestTemplate restTemplate = new RestTemplate();
        ResponseEntity response = restTemplate.postForEntity("https://sketchfab.com/oauth2/token/", this.authRequest((MultiValueMap<String, String>)map), AuthResponse.class, new Object[0]);
        log.debug("Refresh response: " + response);
        return (AuthResponse)response.getBody();
    }

    @GetMapping(value={"/download"})
    public ResponseEntity<GltfModel> download(String uid, HttpServletRequest request) {
        GltfModel model;
        if (this.token == null) {
            this.referrer = request.getHeader("Referer");
            return new ResponseEntity((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        }
        Optional<GltfModel> existing = this.db.findGltfModelByUid(uid);
        if (existing.isPresent()) {
            model = existing.get();
            log.warn("Model already already exists: " + existing.get().getId());
            File modelFile = new File(ClassUtil.projectHomeDirectory() + "/content/" + model.mainCategory() + "/" + model.getFileName());
            if (modelFile.exists()) {
                log.warn("Model directory also exists, exiting: " + modelFile);
                return new ResponseEntity((Object)model, (HttpStatusCode)HttpStatus.OK);
            }
            log.warn("Model directory does not exist, downloading again");
        }
        String url = "https://api.sketchfab.com/v3/models/" + uid + "/download";
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = new HttpHeaders();
        headers.setBearerAuth(this.token);
        HttpEntity entity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = restTemplate.exchange(url, HttpMethod.GET, entity, DownloadResponse.class, new Object[0]);
        log.debug("Download response: " + response);
        FileInfo gltf = ((DownloadResponse)response.getBody()).getGltf();
        try {
            model = this.modelInfo(uid);
            if (existing.isPresent()) {
                model.setId(existing.get().getId());
                log.warn("Overriding existing model data " + model.getId());
            }
            String category = model.mainCategory();
            URL fileUrl = new URL(gltf.getUrl());
            String fileName = fileUrl.getPath();
            fileName = fileName.substring(fileName.lastIndexOf("/") + 1);
            String modelName = fileName.substring(0, fileName.lastIndexOf("."));
            modelName = modelName.replaceAll("\\.", "");
            File modelDir = new File(FileUtil.contentDir() + "/" + category + "/" + modelName);
            if (modelDir.exists()) {
                log.warn("Destination directory already exists, download skipped: " + modelDir);
            } else {
                log.info("Downloading " + gltf.getUrl() + " size " + gltf.getSize());
                File file = new File(FileUtil.downloadDir(), fileName);
                IOUtils.copy((URL)fileUrl, (File)file);
                log.info("Downloaded to " + file.getCanonicalPath());
                Path dest = FileUtil.unzip(file, modelDir);
                log.info("Unzipped to " + dest);
            }
            model.setFileName(modelDir.getName());
            model.setMesh("/content/" + model.mainCategory() + "/" + model.getFileName() + "/scene.gltf");
            this.db.save(model);
            log.info("Stored " + model);
            return new ResponseEntity((Object)model, (HttpStatusCode)HttpStatus.OK);
        }
        catch (Exception e) {
            throw new RuntimeException("Error downloading " + gltf.getUrl(), e);
        }
    }

    private GltfModel modelInfo(String uid) throws JsonMappingException, JsonProcessingException {
        GltfModel ret = new GltfModel();
        RestTemplate restTemplate = new RestTemplate();
        String url = "https://api.sketchfab.com/v3/models/" + uid;
        String json = (String)restTemplate.getForEntity(url, String.class, new Object[0]).getBody();
        log.debug("Model info: " + json);
        Map info = (Map)this.objectMapper.readValue(json, Map.class);
        ret.setUid((String)info.get("uid"));
        ret.setUri((String)info.get("uri"));
        ret.setName((String)info.get("name"));
        ret.setDescription((String)info.get("description"));
        ret.setLicense((String)((Map)info.get("license")).get("slug"));
        ret.setAuthor((String)((Map)info.get("user")).get("displayName"));
        List categories = (List)info.get("categories");
        for (Map category : categories) {
            log.debug("Category: " + category.get("slug") + " " + category.get("name"));
            String catName = (String)category.get("slug");
            Optional<ContentCategory> oCat = this.db.findContentCategoryByName(catName);
            if (oCat.isPresent()) {
                ret.getCategories().add(oCat.get());
                continue;
            }
            ContentCategory cat = new ContentCategory(catName);
            cat = (ContentCategory)this.db.save(cat);
            ret.getCategories().add(cat);
        }
        return ret;
    }

    public static class LoginResponse {
        String url;

        @Generated
        public String getUrl() {
            return this.url;
        }

        @Generated
        public void setUrl(String url) {
            this.url = url;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LoginResponse)) {
                return false;
            }
            LoginResponse other = (LoginResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            return !(this$url == null ? other$url != null : !this$url.equals(other$url));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof LoginResponse;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SketchfabController.LoginResponse(url=" + this.getUrl() + ")";
        }

        @Generated
        public LoginResponse() {
        }

        @Generated
        public LoginResponse(String url) {
            this.url = url;
        }
    }

    public static class AuthResponse {
        private String access_token;
        private int expires_in;
        private String token_type;
        private String scope;
        private String refresh_token;

        @Generated
        public String getAccess_token() {
            return this.access_token;
        }

        @Generated
        public int getExpires_in() {
            return this.expires_in;
        }

        @Generated
        public String getToken_type() {
            return this.token_type;
        }

        @Generated
        public String getScope() {
            return this.scope;
        }

        @Generated
        public String getRefresh_token() {
            return this.refresh_token;
        }

        @Generated
        public void setAccess_token(String access_token) {
            this.access_token = access_token;
        }

        @Generated
        public void setExpires_in(int expires_in) {
            this.expires_in = expires_in;
        }

        @Generated
        public void setToken_type(String token_type) {
            this.token_type = token_type;
        }

        @Generated
        public void setScope(String scope) {
            this.scope = scope;
        }

        @Generated
        public void setRefresh_token(String refresh_token) {
            this.refresh_token = refresh_token;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AuthResponse)) {
                return false;
            }
            AuthResponse other = (AuthResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getExpires_in() != other.getExpires_in()) {
                return false;
            }
            String this$access_token = this.getAccess_token();
            String other$access_token = other.getAccess_token();
            if (this$access_token == null ? other$access_token != null : !this$access_token.equals(other$access_token)) {
                return false;
            }
            String this$token_type = this.getToken_type();
            String other$token_type = other.getToken_type();
            if (this$token_type == null ? other$token_type != null : !this$token_type.equals(other$token_type)) {
                return false;
            }
            String this$scope = this.getScope();
            String other$scope = other.getScope();
            if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
                return false;
            }
            String this$refresh_token = this.getRefresh_token();
            String other$refresh_token = other.getRefresh_token();
            return !(this$refresh_token == null ? other$refresh_token != null : !this$refresh_token.equals(other$refresh_token));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AuthResponse;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getExpires_in();
            String $access_token = this.getAccess_token();
            result = result * 59 + ($access_token == null ? 43 : $access_token.hashCode());
            String $token_type = this.getToken_type();
            result = result * 59 + ($token_type == null ? 43 : $token_type.hashCode());
            String $scope = this.getScope();
            result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
            String $refresh_token = this.getRefresh_token();
            result = result * 59 + ($refresh_token == null ? 43 : $refresh_token.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SketchfabController.AuthResponse(access_token=" + this.getAccess_token() + ", expires_in=" + this.getExpires_in() + ", token_type=" + this.getToken_type() + ", scope=" + this.getScope() + ", refresh_token=" + this.getRefresh_token() + ")";
        }

        @Generated
        public AuthResponse() {
        }
    }

    public static class DownloadResponse {
        private FileInfo gltf;
        private FileInfo usdz;

        @Generated
        public FileInfo getGltf() {
            return this.gltf;
        }

        @Generated
        public FileInfo getUsdz() {
            return this.usdz;
        }

        @Generated
        public void setGltf(FileInfo gltf) {
            this.gltf = gltf;
        }

        @Generated
        public void setUsdz(FileInfo usdz) {
            this.usdz = usdz;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DownloadResponse)) {
                return false;
            }
            DownloadResponse other = (DownloadResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            FileInfo this$gltf = this.getGltf();
            FileInfo other$gltf = other.getGltf();
            if (this$gltf == null ? other$gltf != null : !((Object)this$gltf).equals(other$gltf)) {
                return false;
            }
            FileInfo this$usdz = this.getUsdz();
            FileInfo other$usdz = other.getUsdz();
            return !(this$usdz == null ? other$usdz != null : !((Object)this$usdz).equals(other$usdz));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof DownloadResponse;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            FileInfo $gltf = this.getGltf();
            result = result * 59 + ($gltf == null ? 43 : ((Object)$gltf).hashCode());
            FileInfo $usdz = this.getUsdz();
            result = result * 59 + ($usdz == null ? 43 : ((Object)$usdz).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SketchfabController.DownloadResponse(gltf=" + this.getGltf() + ", usdz=" + this.getUsdz() + ")";
        }

        @Generated
        public DownloadResponse() {
        }
    }

    public static class FileInfo {
        private String url;
        private long size;
        private int expires;

        @Generated
        public String getUrl() {
            return this.url;
        }

        @Generated
        public long getSize() {
            return this.size;
        }

        @Generated
        public int getExpires() {
            return this.expires;
        }

        @Generated
        public void setUrl(String url) {
            this.url = url;
        }

        @Generated
        public void setSize(long size) {
            this.size = size;
        }

        @Generated
        public void setExpires(int expires) {
            this.expires = expires;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileInfo)) {
                return false;
            }
            FileInfo other = (FileInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getSize() != other.getSize()) {
                return false;
            }
            if (this.getExpires() != other.getExpires()) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            return !(this$url == null ? other$url != null : !this$url.equals(other$url));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof FileInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $size = this.getSize();
            result = result * 59 + (int)($size >>> 32 ^ $size);
            result = result * 59 + this.getExpires();
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SketchfabController.FileInfo(url=" + this.getUrl() + ", size=" + this.getSize() + ", expires=" + this.getExpires() + ")";
        }

        @Generated
        public FileInfo() {
        }
    }
}

