/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.core;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.DependsOn;
import org.springframework.data.neo4j.repository.Neo4jRepository;
import org.springframework.data.neo4j.repository.query.Query;
import org.springframework.util.StringUtils;
import org.vrspace.server.core.VRSpaceDB;
import org.vrspace.server.dto.WorldStatus;
import org.vrspace.server.obj.Client;
import org.vrspace.server.obj.ContentCategory;
import org.vrspace.server.obj.Embedded;
import org.vrspace.server.obj.Entity;
import org.vrspace.server.obj.GltfModel;
import org.vrspace.server.obj.Ownership;
import org.vrspace.server.obj.Point;
import org.vrspace.server.obj.TerrainPoint;
import org.vrspace.server.obj.VRObject;
import org.vrspace.server.obj.World;

@DependsOn(value={"database"})
public interface VRObjectRepository
extends Neo4jRepository<Entity, Long>,
VRSpaceDB {
    public static final Logger log = LoggerFactory.getLogger(VRObjectRepository.class);

    default public Optional<Entity> findById(Long id) {
        throw new UnsupportedOperationException("This doesn't work, use findById(Class<T> cls, Long id) instead");
    }

    default public void deleteById(Long id) {
        throw new UnsupportedOperationException("This doesn't work, use deleteById(Class<T> cls, Long id) instead");
    }

    @Query(value="MATCH (o:VRObject{permanent:true}) WHERE o.worldId=$worldId RETURN o")
    public Set<VRObject> getPermanents(Long var1);

    default public Client getClient(Long id) {
        return (Client)this.get(Client.class, id);
    }

    @Query(value="MATCH (o:VRObject) WHERE o.worldId = $worldId RETURN o")
    public Set<VRObject> getAllInWorld(Long var1);

    default public void deleteWorld(World world) {
        Set<VRObject> objects = this.getAllInWorld(world.getId());
        objects.forEach(o -> this.delete((VRObject)o));
        this.deleteById(world.getClass(), world.getId());
    }

    @Query(value="MATCH (o:World) WHERE o.name = $name RETURN o")
    public World getWorldByName(String var1);

    default public Set<VRObject> getRange(Long worldId, Point from, Point to) {
        return this.getRange(worldId, from.getX(), from.getY(), from.getZ(), to.getX(), to.getY(), to.getZ());
    }

    @Query(value="MATCH (o:VRObject)-[r:HAS_POSITION]->(p:Point) WHERE o.worldId = $worldId AND p.x >= $x1 AND p.y >= $y1 AND p.z >= $z1 AND p.x <= $x2 AND p.y <= $y2 AND p.z <= $z2 RETURN o,r,p")
    public Set<VRObject> getRange(Long var1, double var2, double var4, double var6, double var8, double var10, double var12);

    default public Set<Point> getPoints(Point from, Point to) {
        return this.getPoints(from.getX(), from.getY(), from.getZ(), to.getX(), to.getY(), to.getZ());
    }

    @Query(value="MATCH (p:Point) WHERE p.x >= $x1 AND p.y >= $y1 AND p.z >= $z1 AND p.x <= $x2 AND p.y <= $y2 AND p.z <= $z2 RETURN p")
    public Set<Point> getPoints(double var1, double var3, double var5, double var7, double var9, double var11);

    @Query(value="MATCH (o:Entity) WHERE ID(o) = $id RETURN o")
    public <T extends Embedded> T getMember(Class<T> var1, Long var2);

    default public void delete(VRObject o) {
        try {
            this.deleteMembers(o.getClass(), o);
            o.dispose();
        }
        catch (Exception e) {
            log.error("Cannot delete members of " + o.getClass().getSimpleName() + " " + o.getId(), (Throwable)e);
        }
        this.deleteById(o.getClass(), o.getId());
        log.debug("Deleted " + o.getClass().getSimpleName() + " " + o.getId());
    }

    default public void deleteMembers(Class<?> cls, VRObject obj) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (VRObject.class.isAssignableFrom(cls.getSuperclass())) {
            this.deleteMembers(cls.getSuperclass(), obj);
        }
        for (Field f : cls.getDeclaredFields()) {
            Method getter;
            Embedded e;
            if (!Embedded.class.isAssignableFrom(f.getType()) || (e = (Embedded)(getter = cls.getMethod("get" + StringUtils.capitalize((String)f.getName()), new Class[0])).invoke((Object)obj, new Object[0])) == null || e.getId() == null) continue;
            log.debug("Deleting " + f.getName() + " " + e.getClass().getSimpleName() + ":" + e.getId() + " of " + obj.getClass().getSimpleName() + " " + obj.getId());
            this.deleteById(e.getClass(), e.getId());
            e.dispose();
        }
    }

    default public void nullSafeDelete(Entity e) {
        if (e != null && e.getId() != null) {
            this.deleteById(e.getClass(), e.getId());
        }
    }

    public Optional<GltfModel> findGltfModelByUid(String var1);

    public Optional<ContentCategory> findContentCategoryByName(String var1);

    @Query(value="MATCH (o:World) RETURN o")
    public List<World> listWorlds();

    @Query(value="MATCH (o:Client) WHERE o.worldId = $worldId RETURN count(*)")
    public int countUsers(long var1);

    @Query(value="MATCH (o:Client) WHERE o.worldId = $worldId AND o.active = $active RETURN count(*)")
    public int countUsers(long var1, boolean var3);

    default public List<WorldStatus> countUsers() {
        ArrayList<WorldStatus> ret = new ArrayList<WorldStatus>();
        for (World world : this.listWorlds()) {
            WorldStatus status = new WorldStatus();
            status.setWorldName(world.getName());
            status.setTotalUsers(this.countUsers(world.getId()));
            status.setActiveUsers(this.countUsers(world.getId(), true));
            ret.add(status);
        }
        return ret;
    }

    @Query(value="MATCH (obj:VRObject)<-[owned:IS_OWNED]-(o:Ownership)-[owns:IS_OWNER]->(c:Client) WHERE ID(c) = $clientId RETURN o,owns,c,owned,obj")
    public List<Ownership> getOwnerships(long var1);

    default public List<Ownership> getOwned(long ownerId) {
        ArrayList<Ownership> ret = new ArrayList<Ownership>();
        for (Ownership o : this.getOwnerships(ownerId)) {
            ret.add((Ownership)this.get(Ownership.class, o.getId()));
        }
        return ret;
    }

    @Query(value="MATCH (obj:VRObject)<-[owned:IS_OWNED]-(o:Ownership)-[owns:IS_OWNER]->(c:Client) WHERE ID(obj) = $objectId RETURN o,owns,c,owned,obj")
    public List<Ownership> getOwnersOf(long var1);

    default public List<Ownership> getOwners(long objectId) {
        ArrayList<Ownership> ret = new ArrayList<Ownership>();
        for (Ownership o : this.getOwnersOf(objectId)) {
            ret.add((Ownership)this.get(Ownership.class, o.getId()));
        }
        return ret;
    }

    @Query(value="MATCH (obj:VRObject)<-[owned:IS_OWNED]-(o:Ownership)-[owns:IS_OWNER]->(c:Client) WHERE ID(c) = $ownerId AND ID(obj) = $ownedId RETURN o,owns,c,owned,obj")
    public Optional<Ownership> findOwnership(long var1, long var3);

    default public Ownership getOwnership(long ownerId, long ownedId) {
        Optional<Ownership> optOwnership = this.findOwnership(ownerId, ownedId);
        if (optOwnership.isPresent()) {
            return (Ownership)this.get(Ownership.class, optOwnership.get().getId());
        }
        return null;
    }

    @Query(value="MATCH (tp:TerrainPoint)-[r:IS_POINT_OF]->(t:Terrain) WHERE ID(t)=$terrainId RETURN tp")
    public Set<TerrainPoint> getTerrainPoints(Long var1);

    @Query(value="MATCH (tp:TerrainPoint)-[r:IS_POINT_OF]->(t:Terrain) WHERE ID(t)=$terrainId and tp.index=$index RETURN tp")
    public TerrainPoint getTerrainPoint(Long var1, Long var2);
}

