/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.core;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.vrspace.server.core.VRObjectRepository;
import org.vrspace.server.obj.VRObject;

@Component
public class WriteBack {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WriteBack.class);
    private VRObjectRepository db;
    private Set<VRObject> objects;
    private volatile boolean active;
    private long delay;
    private volatile long totalRequests;
    private volatile long totalWritten;
    private volatile long lastFlush;
    private volatile boolean writing;

    public WriteBack(VRObjectRepository db) {
        new ConcurrentHashMap();
        this.objects = ConcurrentHashMap.newKeySet();
        this.active = true;
        this.delay = 1000L;
        this.totalRequests = 0L;
        this.totalWritten = 0L;
        this.lastFlush = 0L;
        this.writing = false;
        this.db = db;
    }

    private void optionallyFlush() {
        if (!this.objects.isEmpty() && this.lastFlush + this.delay < System.currentTimeMillis()) {
            this.flush();
        }
    }

    public void flush() {
        if (!this.active || this.writing) {
            return;
        }
        this.writing = true;
        long time = System.currentTimeMillis();
        this.totalWritten += (long)this.objects.size();
        this.lastFlush = System.currentTimeMillis();
        try {
            this.db.saveAll(this.objects);
            long saveTime = System.currentTimeMillis() - time;
            log.debug("Wrote " + this.objects.size() + " in " + saveTime + " ms");
            if (saveTime > this.delay) {
                log.warn("Save time " + saveTime + " longer than delay " + this.delay + ", increasing");
                this.delay = saveTime + 1000L;
            }
        }
        catch (Exception e) {
            this.active = false;
            log.error("Write error, writeback disabled", (Throwable)e);
        }
        this.objects.clear();
        this.writing = false;
    }

    public int size() {
        return this.objects.size();
    }

    public long writes() {
        return this.totalWritten;
    }

    public long writeRequests() {
        return this.totalRequests;
    }

    public void write(VRObject o) {
        if (o.getId() == null) {
            throw new IllegalArgumentException("New objects can't be written back, save them first to obtain id");
        }
        if (this.active) {
            ++this.totalRequests;
            this.objects.add(o);
            this.optionallyFlush();
        } else {
            this.db.save(o);
        }
    }

    public void delete(VRObject o) {
        if (this.active) {
            this.objects.remove(o);
            this.flush();
        }
        this.db.delete(o);
    }

    @Generated
    public void setActive(boolean active) {
        this.active = active;
    }

    @Generated
    public boolean isActive() {
        return this.active;
    }

    @Generated
    public void setDelay(long delay) {
        this.delay = delay;
    }

    @Generated
    public long getDelay() {
        return this.delay;
    }
}

