/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.obj;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.Transient;
import org.springframework.data.neo4j.core.schema.Node;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;
import org.vrspace.server.obj.Bot;
import org.vrspace.server.obj.Client;

@Node
public class ArthurBot
extends Bot {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ArthurBot.class);
    @JsonIgnore
    @Transient
    private RestTemplate restTemplate = new RestTemplate();

    @Override
    public void selfTest() throws Exception {
        ResponseEntity<String> result = this.sendQuery("hello world");
        if (result.getStatusCodeValue() != 200) {
            throw new IllegalStateException("Invalid response code: " + result.getStatusCodeValue());
        }
        String response = (String)result.getBody();
        log.debug(this + " initial response: " + response);
        List contentType = result.getHeaders().get((Object)"Content-Type");
        if (contentType.size() == 0) {
            throw new IllegalStateException("Invalid response - no content type");
        }
        if (contentType.size() == 1) {
            String cType = (String)contentType.get(0);
            log.debug("Response content type: " + cType);
            if (!"application/json".equals(cType)) {
                throw new IllegalStateException("Invalid response content type: " + contentType);
            }
        } else {
            throw new IllegalStateException("Invalid response content type - size " + contentType.size() + " " + contentType);
        }
        log.debug(this.getResponse(null, "hello again"));
    }

    @Override
    public String getResponse(Client c, String query) {
        String ret = "";
        try {
            ResponseEntity<String> result = this.sendQuery(query);
            Response response = (Response)this.getMapper().readValue((String)result.getBody(), Response.class);
            ret = response.getResponse();
        }
        catch (Exception e) {
            log.error("Can't get response to: " + query, (Throwable)e);
        }
        return ret;
    }

    private ResponseEntity<String> sendQuery(String what) throws Exception {
        log.debug(this + " request: " + what);
        String encoded = URLEncoder.encode(what, StandardCharsets.UTF_8.toString());
        URI uri = new URI(this.getUrl() + encoded);
        ResponseEntity result = this.restTemplate.getForEntity(uri, String.class);
        log.debug(this + " response: " + (String)result.getBody());
        return result;
    }

    @Generated
    public ArthurBot() {
    }

    @Generated
    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    @JsonIgnore
    @Generated
    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArthurBot)) {
            return false;
        }
        ArthurBot other = (ArthurBot)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ArthurBot;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "ArthurBot(super=" + super.toString() + ")";
    }

    public static class Response {
        private String response;

        @Generated
        public String getResponse() {
            return this.response;
        }

        @Generated
        public void setResponse(String response) {
            this.response = response;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Response)) {
                return false;
            }
            Response other = (Response)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$response = this.getResponse();
            String other$response = other.getResponse();
            return !(this$response == null ? other$response != null : !this$response.equals(other$response));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Response;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $response = this.getResponse();
            result = result * 59 + ($response == null ? 43 : $response.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ArthurBot.Response(response=" + this.getResponse() + ")";
        }

        @Generated
        public Response() {
        }
    }
}

