/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.obj;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.net.URI;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.Transient;
import org.springframework.data.neo4j.core.schema.Node;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;
import org.vrspace.server.obj.Bot;
import org.vrspace.server.obj.Client;

@Node
public class BotLibre
extends Bot {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BotLibre.class);
    @JsonIgnore
    @Transient
    private RestTemplate restTemplate = new RestTemplate();

    @Override
    public void selfTest() throws Exception {
        ResponseEntity<String> result = this.sendQuery(new Client(), "hello world");
        if (result.getStatusCodeValue() != 200) {
            throw new IllegalStateException("Invalid response code: " + result.getStatusCodeValue());
        }
        String response = (String)result.getBody();
        log.debug(this + " initial response: " + response);
        List contentType = result.getHeaders().get((Object)"Content-Type");
        if (contentType.size() == 0) {
            throw new IllegalStateException("Invalid response - no content type");
        }
        if (contentType.size() == 1) {
            String cType = (String)contentType.get(0);
            log.debug("Response content type: " + cType);
            if (!"application/json".equals(cType)) {
                throw new IllegalStateException("Invalid response content type: " + contentType);
            }
        } else {
            throw new IllegalStateException("Invalid response content type - size " + contentType.size() + " " + contentType);
        }
        log.debug(this.getResponse(new Client(), "hello again"));
    }

    @Override
    public String getResponse(Client client, String message) {
        String ret = "";
        try {
            ResponseEntity<String> result = this.sendQuery(client, message);
            Response response = (Response)this.getMapper().readValue((String)result.getBody(), Response.class);
            ret = response.getMessage();
            String conversationId = response.getConversation();
            client.setToken(this.serviceId(), conversationId);
        }
        catch (Exception e) {
            log.error("Can't get response to: " + message, (Throwable)e);
        }
        return ret;
    }

    private ResponseEntity<String> sendQuery(Client client, String message) throws Exception {
        Query q = new Query();
        q.setApplication(this.getParameter("application"));
        q.setInstance(this.getParameter("instance"));
        q.setConversation(client.getToken(this.serviceId()));
        q.setMessage(message);
        log.debug(this + " request: " + q);
        URI uri = new URI(this.getUrl());
        String body = this.getMapper().writeValueAsString((Object)q);
        RequestEntity requestEntity = RequestEntity.post((URI)uri).contentType(MediaType.APPLICATION_JSON).body((Object)body);
        ResponseEntity result = this.restTemplate.exchange(requestEntity, String.class);
        log.debug(this + " response: " + (String)result.getBody());
        return result;
    }

    private String serviceId() {
        return this.getObjectId().toString();
    }

    @Generated
    public BotLibre() {
    }

    @Generated
    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    @JsonIgnore
    @Generated
    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BotLibre)) {
            return false;
        }
        BotLibre other = (BotLibre)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BotLibre;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "BotLibre(super=" + super.toString() + ")";
    }

    public static class Response {
        private String message;
        private String conversation;
        private String emote;
        private String avatar;
        private String avatarType;
        private String avatarTalk;
        private String avatarTalkType;
        private String avatarBackground;

        @Generated
        public String getMessage() {
            return this.message;
        }

        @Generated
        public String getConversation() {
            return this.conversation;
        }

        @Generated
        public String getEmote() {
            return this.emote;
        }

        @Generated
        public String getAvatar() {
            return this.avatar;
        }

        @Generated
        public String getAvatarType() {
            return this.avatarType;
        }

        @Generated
        public String getAvatarTalk() {
            return this.avatarTalk;
        }

        @Generated
        public String getAvatarTalkType() {
            return this.avatarTalkType;
        }

        @Generated
        public String getAvatarBackground() {
            return this.avatarBackground;
        }

        @Generated
        public void setMessage(String message) {
            this.message = message;
        }

        @Generated
        public void setConversation(String conversation) {
            this.conversation = conversation;
        }

        @Generated
        public void setEmote(String emote) {
            this.emote = emote;
        }

        @Generated
        public void setAvatar(String avatar) {
            this.avatar = avatar;
        }

        @Generated
        public void setAvatarType(String avatarType) {
            this.avatarType = avatarType;
        }

        @Generated
        public void setAvatarTalk(String avatarTalk) {
            this.avatarTalk = avatarTalk;
        }

        @Generated
        public void setAvatarTalkType(String avatarTalkType) {
            this.avatarTalkType = avatarTalkType;
        }

        @Generated
        public void setAvatarBackground(String avatarBackground) {
            this.avatarBackground = avatarBackground;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Response)) {
                return false;
            }
            Response other = (Response)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            String this$conversation = this.getConversation();
            String other$conversation = other.getConversation();
            if (this$conversation == null ? other$conversation != null : !this$conversation.equals(other$conversation)) {
                return false;
            }
            String this$emote = this.getEmote();
            String other$emote = other.getEmote();
            if (this$emote == null ? other$emote != null : !this$emote.equals(other$emote)) {
                return false;
            }
            String this$avatar = this.getAvatar();
            String other$avatar = other.getAvatar();
            if (this$avatar == null ? other$avatar != null : !this$avatar.equals(other$avatar)) {
                return false;
            }
            String this$avatarType = this.getAvatarType();
            String other$avatarType = other.getAvatarType();
            if (this$avatarType == null ? other$avatarType != null : !this$avatarType.equals(other$avatarType)) {
                return false;
            }
            String this$avatarTalk = this.getAvatarTalk();
            String other$avatarTalk = other.getAvatarTalk();
            if (this$avatarTalk == null ? other$avatarTalk != null : !this$avatarTalk.equals(other$avatarTalk)) {
                return false;
            }
            String this$avatarTalkType = this.getAvatarTalkType();
            String other$avatarTalkType = other.getAvatarTalkType();
            if (this$avatarTalkType == null ? other$avatarTalkType != null : !this$avatarTalkType.equals(other$avatarTalkType)) {
                return false;
            }
            String this$avatarBackground = this.getAvatarBackground();
            String other$avatarBackground = other.getAvatarBackground();
            return !(this$avatarBackground == null ? other$avatarBackground != null : !this$avatarBackground.equals(other$avatarBackground));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Response;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            String $conversation = this.getConversation();
            result = result * 59 + ($conversation == null ? 43 : $conversation.hashCode());
            String $emote = this.getEmote();
            result = result * 59 + ($emote == null ? 43 : $emote.hashCode());
            String $avatar = this.getAvatar();
            result = result * 59 + ($avatar == null ? 43 : $avatar.hashCode());
            String $avatarType = this.getAvatarType();
            result = result * 59 + ($avatarType == null ? 43 : $avatarType.hashCode());
            String $avatarTalk = this.getAvatarTalk();
            result = result * 59 + ($avatarTalk == null ? 43 : $avatarTalk.hashCode());
            String $avatarTalkType = this.getAvatarTalkType();
            result = result * 59 + ($avatarTalkType == null ? 43 : $avatarTalkType.hashCode());
            String $avatarBackground = this.getAvatarBackground();
            result = result * 59 + ($avatarBackground == null ? 43 : $avatarBackground.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BotLibre.Response(message=" + this.getMessage() + ", conversation=" + this.getConversation() + ", emote=" + this.getEmote() + ", avatar=" + this.getAvatar() + ", avatarType=" + this.getAvatarType() + ", avatarTalk=" + this.getAvatarTalk() + ", avatarTalkType=" + this.getAvatarTalkType() + ", avatarBackground=" + this.getAvatarBackground() + ")";
        }

        @Generated
        public Response() {
        }
    }

    public static class Query {
        private String application;
        private String instance;
        private String conversation;
        private String message;
        private String emote;
        private boolean correction;
        private boolean offensive;
        private boolean disconnect;
        private boolean includeQuestion;

        @Generated
        public String getApplication() {
            return this.application;
        }

        @Generated
        public String getInstance() {
            return this.instance;
        }

        @Generated
        public String getConversation() {
            return this.conversation;
        }

        @Generated
        public String getMessage() {
            return this.message;
        }

        @Generated
        public String getEmote() {
            return this.emote;
        }

        @Generated
        public boolean isCorrection() {
            return this.correction;
        }

        @Generated
        public boolean isOffensive() {
            return this.offensive;
        }

        @Generated
        public boolean isDisconnect() {
            return this.disconnect;
        }

        @Generated
        public boolean isIncludeQuestion() {
            return this.includeQuestion;
        }

        @Generated
        public void setApplication(String application) {
            this.application = application;
        }

        @Generated
        public void setInstance(String instance) {
            this.instance = instance;
        }

        @Generated
        public void setConversation(String conversation) {
            this.conversation = conversation;
        }

        @Generated
        public void setMessage(String message) {
            this.message = message;
        }

        @Generated
        public void setEmote(String emote) {
            this.emote = emote;
        }

        @Generated
        public void setCorrection(boolean correction) {
            this.correction = correction;
        }

        @Generated
        public void setOffensive(boolean offensive) {
            this.offensive = offensive;
        }

        @Generated
        public void setDisconnect(boolean disconnect) {
            this.disconnect = disconnect;
        }

        @Generated
        public void setIncludeQuestion(boolean includeQuestion) {
            this.includeQuestion = includeQuestion;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Query)) {
                return false;
            }
            Query other = (Query)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isCorrection() != other.isCorrection()) {
                return false;
            }
            if (this.isOffensive() != other.isOffensive()) {
                return false;
            }
            if (this.isDisconnect() != other.isDisconnect()) {
                return false;
            }
            if (this.isIncludeQuestion() != other.isIncludeQuestion()) {
                return false;
            }
            String this$application = this.getApplication();
            String other$application = other.getApplication();
            if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
                return false;
            }
            String this$instance = this.getInstance();
            String other$instance = other.getInstance();
            if (this$instance == null ? other$instance != null : !this$instance.equals(other$instance)) {
                return false;
            }
            String this$conversation = this.getConversation();
            String other$conversation = other.getConversation();
            if (this$conversation == null ? other$conversation != null : !this$conversation.equals(other$conversation)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            String this$emote = this.getEmote();
            String other$emote = other.getEmote();
            return !(this$emote == null ? other$emote != null : !this$emote.equals(other$emote));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Query;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isCorrection() ? 79 : 97);
            result = result * 59 + (this.isOffensive() ? 79 : 97);
            result = result * 59 + (this.isDisconnect() ? 79 : 97);
            result = result * 59 + (this.isIncludeQuestion() ? 79 : 97);
            String $application = this.getApplication();
            result = result * 59 + ($application == null ? 43 : $application.hashCode());
            String $instance = this.getInstance();
            result = result * 59 + ($instance == null ? 43 : $instance.hashCode());
            String $conversation = this.getConversation();
            result = result * 59 + ($conversation == null ? 43 : $conversation.hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            String $emote = this.getEmote();
            result = result * 59 + ($emote == null ? 43 : $emote.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BotLibre.Query(application=" + this.getApplication() + ", instance=" + this.getInstance() + ", conversation=" + this.getConversation() + ", message=" + this.getMessage() + ", emote=" + this.getEmote() + ", correction=" + this.isCorrection() + ", offensive=" + this.isOffensive() + ", disconnect=" + this.isDisconnect() + ", includeQuestion=" + this.isIncludeQuestion() + ")";
        }

        @Generated
        public Query() {
        }
    }
}

