/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.core;

import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.nimbusds.oauth2.sdk.util.StringUtils;
import io.openvidu.java.client.OpenViduException;
import jakarta.annotation.PostConstruct;
import jakarta.servlet.http.HttpSession;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.data.neo4j.core.mapping.Neo4jMappingContext;
import org.springframework.http.HttpHeaders;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.socket.handler.ConcurrentWebSocketSessionDecorator;
import org.vrspace.server.config.ServerConfig;
import org.vrspace.server.config.WorldConfig;
import org.vrspace.server.core.ClassUtil;
import org.vrspace.server.core.ClientFactory;
import org.vrspace.server.core.Dispatcher;
import org.vrspace.server.core.PersistenceManager;
import org.vrspace.server.core.Scene;
import org.vrspace.server.core.SessionException;
import org.vrspace.server.core.SessionTracker;
import org.vrspace.server.core.StreamManager;
import org.vrspace.server.core.VRObjectRepository;
import org.vrspace.server.core.WriteBack;
import org.vrspace.server.dto.ClientRequest;
import org.vrspace.server.dto.ClientResponse;
import org.vrspace.server.dto.Command;
import org.vrspace.server.dto.SceneProperties;
import org.vrspace.server.dto.VREvent;
import org.vrspace.server.dto.Welcome;
import org.vrspace.server.obj.Client;
import org.vrspace.server.obj.Entity;
import org.vrspace.server.obj.Ownership;
import org.vrspace.server.obj.Point;
import org.vrspace.server.obj.RemoteServer;
import org.vrspace.server.obj.User;
import org.vrspace.server.obj.VRObject;
import org.vrspace.server.obj.World;
import org.vrspace.server.types.ID;

@Component(value="world")
@DependsOn(value={"database"})
public class WorldManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorldManager.class);
    @Autowired
    protected ServerConfig config;
    @Autowired
    private VRObjectRepository db;
    @Autowired
    protected SceneProperties sceneProperties;
    @Autowired
    protected ObjectMapper jackson;
    private ObjectMapper privateJackson;
    @Autowired
    private StreamManager streamManager;
    @Autowired
    protected ClientFactory clientFactory;
    @Autowired
    private Neo4jMappingContext mappingContext;
    @Autowired
    private WorldConfig worldConfig;
    private Dispatcher dispatcher;
    protected SessionTracker sessionTracker;
    protected ConcurrentHashMap<ID, Entity> cache = new ConcurrentHashMap();
    private World defaultWorld;
    private Map<Class, PersistenceManager> persistors = new HashMap<Class, PersistenceManager>();

    @PostConstruct
    public void init() {
        this.privateJackson = this.jackson.copy();
        this.privateJackson.setAnnotationIntrospector((AnnotationIntrospector)new JacksonAnnotationIntrospector());
        this.dispatcher = new Dispatcher(this.privateJackson);
        this.sessionTracker = new SessionTracker(this.config);
        for (Class<?> c : ClassUtil.findSubclasses(PersistenceManager.class)) {
            for (Type t : ((ParameterizedType)c.getGenericSuperclass()).getActualTypeArguments()) {
                try {
                    PersistenceManager p = (PersistenceManager)c.getConstructor(VRObjectRepository.class).newInstance(this.db);
                    this.persistors.put((Class)t, p);
                }
                catch (Exception e) {
                    log.error("Failed to instantiate " + c, (Throwable)e);
                }
            }
        }
        PersistenceManager pm = new PersistenceManager();
        for (Class<?> c : ClassUtil.findSubclasses(Entity.class)) {
            if (this.persistors.get(c) != null) continue;
            this.persistors.put(c, pm);
        }
        this.createWorlds();
    }

    private void createWorlds() {
        this.defaultWorld();
        for (String worldName : this.worldConfig.getWorld().keySet()) {
            WorldConfig.WorldProperties wp = this.worldConfig.getWorld().get(worldName);
            log.info("Configuring world: " + worldName);
            World world = this.getWorld(worldName);
            if (world == null) {
                log.info("World " + worldName + " to be created as " + wp);
                try {
                    Object className = wp.getType();
                    if (!((String)className).contains(".")) {
                        className = "org.vrspace.server.obj." + (String)className;
                    }
                    Class<?> c = Class.forName((String)className);
                    world = (World)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception e) {
                    log.error("Error configuring world " + worldName, (Throwable)e);
                }
            } else {
                log.info("World " + worldName + " already exists : " + world);
            }
            BeanUtils.copyProperties((Object)wp, (Object)world);
            this.db.save(world);
        }
        log.info("WorldManager ready");
    }

    public VRObject get(ID id) {
        return (VRObject)this.cache.get(id);
    }

    public <T extends VRObject> T get(Class<T> cls, Long id) {
        return (T)((VRObject)this.cache.get(new ID(cls, id)));
    }

    public List<Entity> find(Predicate<? super Entity> filter) {
        return this.cache.values().stream().filter(filter).collect(Collectors.toList());
    }

    public List<Class<?>> listClasses() {
        return this.mappingContext.getManagedTypes().stream().filter(info -> !Modifier.isAbstract(info.getType().getModifiers()) && Entity.class.isAssignableFrom(info.getType())).map(i -> i.getType()).collect(Collectors.toList());
    }

    public World getWorld(String name) {
        Optional<Entity> existing = this.cache.values().stream().filter(o -> o.getClass().equals(World.class) && ((World)o).getName().equals(name)).findFirst();
        if (existing.isPresent()) {
            return (World)existing.get();
        }
        World ret = this.db.getWorldByName(name);
        return (World)this.updateCache(ret);
    }

    private void deleteWorld(World world) {
        this.cache.remove(world.getObjectId());
        this.db.deleteWorld(world);
    }

    public World saveWorld(World world) {
        world = (World)this.db.save(world);
        this.cache.put(world.getObjectId(), world);
        return world;
    }

    private synchronized World createWorld(String name) {
        World world = this.getWorld(name);
        if (world == null) {
            log.info("Creating temporary world on demand: " + name);
            world = new World(name);
            world.setTemporaryWorld(true);
            world = this.saveWorld(world);
        }
        return world;
    }

    public World getOrCreateWorld(String name) {
        World world = this.getWorld(name);
        if (world == null) {
            if (this.config.isCreateWorlds()) {
                world = this.createWorld(name);
            } else {
                throw new IllegalArgumentException("Unknown world: " + name);
            }
        }
        return world;
    }

    public Client getClient(Long id) {
        Client ret = (Client)this.db.get(Client.class, id);
        return (Client)this.updateCache(ret);
    }

    public Client getClientByName(String name) {
        Client ret = this.db.getClientByName(name);
        return (Client)this.updateCache(ret);
    }

    public <T extends Client> T getClientByName(String name, Class<T> cls) {
        Client ret = this.db.getClientByName(name, cls);
        return (T)((Client)this.updateCache(ret));
    }

    public <T extends VRObject> T save(T obj) {
        VRObject ret = (VRObject)this.db.save(obj);
        this.cache.put(obj.getObjectId(), ret);
        return (T)ret;
    }

    public Set<VRObject> getRange(Client client, Point from, Point to) {
        return this.updateCache(this.db.getRange(client.getWorldId(), from, to));
    }

    public Set<VRObject> getPermanents(Client client) {
        return this.updateCache(this.db.getPermanents(client.getWorldId()));
    }

    private Set<VRObject> updateCache(Set<VRObject> objects) {
        HashSet<VRObject> ret = new HashSet<VRObject>();
        for (Entity entity : objects) {
            VRObject persisted = (VRObject)this.updateCache(entity);
            if (persisted == null) continue;
            ret.add(persisted);
        }
        return ret;
    }

    private Entity updateCache(Entity o) {
        if (o != null) {
            ID id = o.getObjectId();
            Entity cached = this.cache.get(id);
            if (cached != null) {
                return cached;
            }
            if ((o = this.db.get(o.getClass(), o.getId())) != null) {
                this.persistors.get(o.getClass()).postLoad(o);
                this.cache.put(id, o);
            }
            return o;
        }
        return null;
    }

    public VRObject add(Client client, VRObject o) {
        if (o.getPosition() == null && client.getPosition() != null) {
            o.setPosition(new Point(client.getPosition()));
        }
        o.setWorld(client.getWorld());
        if (o.getTemporary() == null && client.isGuest()) {
            o.setTemporary(true);
        }
        o = (VRObject)this.db.save(o);
        Ownership ownership = new Ownership(client, o);
        this.db.save(ownership);
        this.cache.put(o.getObjectId(), o);
        return o;
    }

    public boolean isOwner(Client client, VRObject o) {
        return this.db.findOwnership(client.getId(), o.getId()).isPresent();
    }

    public List<VRObject> add(Client client, List<VRObject> objects) {
        List<VRObject> ret = objects.stream().map(o -> this.add(client, (VRObject)o)).collect(Collectors.toList());
        this.db.save(client);
        return ret;
    }

    public void remove(Client client, VRObject obj) {
        Ownership own = this.db.getOwnership(client.getId(), obj.getId());
        if (own == null) {
            throw new SecurityException("Not yours to remove: " + obj.getClass().getSimpleName() + " " + obj.getId());
        }
        this.db.delete(own);
        this.db.save(client);
        this.delete(client, obj);
    }

    private void delete(Client client, VRObject obj) {
        obj.setDeleted(true);
        client.getWriteBack().delete(obj);
        this.cache.remove(obj.getObjectId());
    }

    @Transactional
    public Welcome login(ConcurrentWebSocketSessionDecorator session) {
        return this.login(session, User.class);
    }

    @Transactional
    public Welcome serverLogin(ConcurrentWebSocketSessionDecorator session) {
        return this.login(session, RemoteServer.class);
    }

    @Transactional
    public Welcome login(ConcurrentWebSocketSessionDecorator session, Class<? extends Client> clientClass) {
        Principal principal = session.getPrincipal();
        HttpHeaders headers = session.getHandshakeHeaders();
        Map attributes = session.getAttributes();
        log.debug("Login principal: " + principal + " headers: " + headers + " attributes: " + attributes);
        Client client = null;
        if (session.getPrincipal() != null) {
            client = this.clientFactory.findClient(clientClass, principal, this.db, headers, attributes);
            if (client == null) {
                throw new SecurityException("Unauthorized client " + session.getPrincipal().getName());
            }
        } else if (this.config.isGuestAllowed()) {
            client = this.clientFactory.createGuestClient(clientClass, headers, attributes);
            if (client == null) {
                throw new SecurityException("Guest disallowed");
            }
            client.setPosition(new Point());
            client = (Client)this.db.save(client);
        } else {
            client = this.clientFactory.handleUnknownClient(clientClass, headers, attributes);
            if (client == null) {
                throw new SecurityException("Unauthorized");
            }
        }
        client.setSession(session);
        HttpSession httpSession = (HttpSession)attributes.get("HTTP.SESSION");
        if (httpSession != null) {
            httpSession.setAttribute("local-user-id", (Object)client.getId());
        }
        this.login(client);
        return this.enter(client, this.defaultWorld());
    }

    public void login(Client client) {
        client.setMapper(this.jackson);
        client.setPrivateMapper(this.privateJackson);
        client.setSceneProperties(this.sceneProperties.newInstance());
        WriteBack writeBack = new WriteBack(this.db);
        writeBack.setActive(this.config.isWriteBackActive());
        writeBack.setDelay(this.config.getWriteBackDelay());
        client.setWriteBack(writeBack);
        this.cache.put(client.getObjectId(), client);
    }

    public World defaultWorld() {
        if (this.defaultWorld == null) {
            this.defaultWorld = this.getWorld("default");
            if (this.defaultWorld == null) {
                this.defaultWorld = (World)this.db.save(new World("default", true));
                this.cache.put(this.defaultWorld.getObjectId(), this.defaultWorld);
                log.info("Created default world: " + this.defaultWorld);
            }
        }
        return this.defaultWorld;
    }

    public Welcome enter(Client client, String worldName) {
        World world = this.getOrCreateWorld(worldName);
        return this.enter(client, world);
    }

    public Welcome enter(Client client, World world) {
        if (client.getWorldId() != null) {
            if (client.getWorldId().equals(world.getId())) {
                throw new IllegalArgumentException("Already in world " + world);
            }
            this.exit(client);
        }
        if (!world.enter(client, this)) {
            throw new SecurityException("Client forbidden to enter the world");
        }
        client.setWorld(world);
        this.streamManager.join(client);
        client = this.save(client);
        Welcome ret = new Welcome(client, this.getPermanents(client));
        return ret;
    }

    public synchronized int startSession(Client client) throws SessionException {
        Client existing;
        if (StringUtils.isNotBlank((CharSequence)client.getName()) && (existing = this.getClientByName(client.getName())) != null && existing.getName() != null && client.getName().equals(existing.getName()) && !existing.getId().equals(client.getId())) {
            throw new SessionException("Client named '" + client.getName() + "' already exists");
        }
        this.sessionTracker.addSession(client);
        if (client.getPosition() == null) {
            client.setPosition(new Point());
        }
        client.setActive(true);
        client = this.save(client);
        return client.createScene(this);
    }

    @Transactional
    public synchronized void logout(Client client) {
        this.sessionTracker.remove(client);
        this.exit(client);
        if (client.isGuest()) {
            this.delete(client, client);
            log.debug("Deleted guest client " + client.getId());
        }
        client.getWriteBack().flush();
    }

    private void exit(Client client) {
        client.setActive(false);
        VREvent ev = new VREvent(client, client);
        ev.addChange("active", false);
        client.notifyListeners(ev);
        List<Ownership> owned = this.db.getOwned(client.getId());
        for (Ownership ownership : owned) {
            VRObject ownedObject = this.get(ownership.getOwned().getObjectId());
            if (!ownedObject.isTemporary() && !client.isGuest()) continue;
            if (client.getScene() != null) {
                client.getScene().unpublish(ownedObject);
            }
            this.delete(client, ownedObject);
            this.db.delete(ownership);
            log.debug("Deleted owned temporary " + ownership.getOwned().getObjectId());
        }
        if (client.getScene() != null) {
            client.getScene().unpublish();
            client.getScene().removeAll();
        }
        client.setListeners(null);
        World world = client.getWorld();
        try {
            this.streamManager.disconnect(client, world.getName());
        }
        catch (OpenViduException e) {
            log.error("Error disconnecting client " + client + " from streaming session", (Throwable)e);
        }
        client.setWorld(null);
        client = this.save(client);
        world.exit(client, this);
        if (world.isTemporaryWorld() && this.db.countUsers(world.getId()) == 0) {
            log.info("Deleting temporary world " + world.getId() + " " + world.getName());
            this.deleteWorld(world);
        }
    }

    @Transactional
    public void dispatch(VREvent event) throws Exception {
        Client client = event.getClient();
        if (client == null) {
            throw new IllegalArgumentException("Event from uknown client " + event);
        }
        Scene scene = client.getScene();
        if (event instanceof ClientRequest && ((ClientRequest)event).isCommand()) {
            Command cmd = ((ClientRequest)event).getCommand();
            ClientResponse ret = cmd.execute(this, client);
            if (ret != null) {
                client.sendMessage(ret);
            }
        } else {
            if (event.sourceIs(client)) {
                event.setSource(client);
            } else {
                if (scene == null) {
                    throw new UnsupportedOperationException("Client has no scene " + client);
                }
                VRObject obj = scene.get(event.getSourceID());
                if (obj == null) {
                    obj = this.get(event.getSourceID());
                }
                if (obj == null) {
                    throw new UnsupportedOperationException("Unknown object: " + event.getSourceID());
                }
                event.setSource(obj);
            }
            Ownership ownership = this.db.getOwnership(client.getId(), event.getSource().getId());
            event.setOwnership(ownership);
            this.dispatcher.dispatch(event);
            try {
                this.persistors.get(event.getSource().getClass()).persist(event);
            }
            catch (Exception e) {
                log.error("Error persisting " + event, (Throwable)e);
            }
            if (scene != null) {
                scene.update();
            }
        }
    }

    public StreamManager getStreamManager() {
        return this.streamManager;
    }
}

