/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.obj;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonMerge;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.neo4j.core.schema.Node;
import org.vrspace.server.obj.Content;
import org.vrspace.server.obj.VRObject;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.WRAPPER_OBJECT)
@Node
public class VRFile
extends VRObject {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VRFile.class);
    public static final String FILE_SCRIPT = "/babylon/js/scripts/shared-file.js";
    public static final String IMAGE_SCRIPT = "/babylon/js/scripts/shared-image.js";
    public static final String VIDEO_SCRIPT = "/babylon/js/scripts/shared-video.js";
    @JsonMerge
    private Content content;

    public VRFile() {
        this.setScript(FILE_SCRIPT);
    }

    public void setContent(Content content) {
        this.content = content;
        if (content != null && content.getContentType() != null) {
            if (content.getContentType().contains("image/")) {
                this.setScript(IMAGE_SCRIPT);
            } else if (content.getContentType().equals("video/mp4") || content.getContentType().equals("video/ogg") || content.getContentType().equals("video/webm")) {
                this.setScript(VIDEO_SCRIPT);
            }
        }
    }

    @Generated
    public Content getContent() {
        return this.content;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VRFile)) {
            return false;
        }
        VRFile other = (VRFile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof VRFile;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "VRFile(super=" + super.toString() + ")";
    }
}

