/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.api;

import com.nimbusds.oauth2.sdk.util.StringUtils;
import jakarta.servlet.http.HttpSession;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.vrspace.server.api.ClientControllerBase;
import org.vrspace.server.config.ServerConfig;
import org.vrspace.server.core.VRObjectRepository;
import org.vrspace.server.obj.Client;
import org.vrspace.server.obj.User;

@RestController
@RequestMapping(value={"/vrspace/api/user"})
public class UserController
extends ClientControllerBase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UserController.class);
    public static final String PATH = "/vrspace/api/user";
    @Autowired
    private VRObjectRepository db;
    @Autowired
    private ServerConfig config;

    @GetMapping(value={"/available"})
    public boolean checkName(String name, HttpSession session) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return this.config.isGuestAllowed();
        }
        Client client = this.db.getClientByName(name);
        String currentName = this.userName(session);
        boolean valid = client == null || client.getName() != null && client.getName().equals(currentName);
        log.debug("Client name " + name + " available for " + currentName + ": " + valid);
        return valid;
    }

    @GetMapping(value={"/authenticated"})
    public boolean authenticated(HttpSession session) {
        return this.isAuthenticated(session);
    }

    @GetMapping(value={"/name"})
    public String userName(HttpSession session) {
        return UserController.currentUserName(session, this.clientFactory);
    }

    @GetMapping(value={"/object"})
    @ResponseBody
    public User userObject(HttpSession session) {
        Client ret;
        String currentName = UserController.currentUserName(session, this.clientFactory);
        if (currentName != null && (ret = this.db.getClientByName(currentName)) instanceof User) {
            return (User)ret;
        }
        return null;
    }

    @GetMapping(value={"/find"})
    @ResponseBody
    public ResponseEntity<Client> find(String name, HttpSession session) {
        this.findClient(session);
        Client client = this.db.getClientByName(name);
        if (client == null) {
            return new ResponseEntity(HttpStatusCode.valueOf((int)404));
        }
        return new ResponseEntity((Object)client, HttpStatusCode.valueOf((int)200));
    }
}

