/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.core;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vrspace.server.core.WorldManager;
import org.vrspace.server.dto.Add;
import org.vrspace.server.dto.Remove;
import org.vrspace.server.dto.SceneProperties;
import org.vrspace.server.obj.Client;
import org.vrspace.server.obj.Point;
import org.vrspace.server.obj.VRObject;
import org.vrspace.server.types.Filter;
import org.vrspace.server.types.ID;

public class Scene {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Scene.class);
    private Point oldPos = new Point();
    private Set<VRObject> members = Scene.newScene();
    protected Set<VRObject> permanents;
    private HashMap<ID, VRObject> allObjects = new HashMap();
    private WorldManager world;
    private Client client;
    private long lastUpdate = 0L;
    private boolean active = false;
    protected SceneProperties props;
    private LinkedHashMap<String, Filter> filters = new LinkedHashMap();

    protected Scene() {
    }

    private static Set<VRObject> newScene() {
        new ConcurrentHashMap();
        return ConcurrentHashMap.newKeySet();
    }

    public Scene(WorldManager world, Client client) {
        this.world = world;
        this.client = client;
        this.props = client.getSceneProperties();
        this.loadPermanents();
    }

    public int size() {
        return this.members.size();
    }

    public void loadPermanents() {
        this.permanents = this.world.getPermanents(this.client);
        this.permanents.stream().filter(p -> p.isActive()).forEach(p -> p.addListener(this.client));
    }

    public void update() {
        try {
            if (this.active) {
                return;
            }
            this.active = true;
            if (!this.client.getPosition().isInRange(this.oldPos, this.props.getResolution()) || System.currentTimeMillis() > this.lastUpdate + this.props.getTimeout()) {
                Set<VRObject> newScene = Scene.newScene();
                Point p1 = new Point(this.client.getPosition()).minus(this.props.getRange());
                Point p2 = new Point(this.client.getPosition()).plus(this.props.getRange());
                Set<VRObject> objects = this.world.getRange(this.client, p1, p2);
                Add add = new Add();
                Remove remove = new Remove();
                objects.stream().filter(t -> this.isVisible((VRObject)t)).forEach(t -> {
                    if (this.members.contains(t)) {
                        this.members.remove(t);
                        newScene.add((VRObject)t);
                    } else {
                        this.add((VRObject)t);
                        newScene.add((VRObject)t);
                        add.addObject((VRObject)t);
                    }
                });
                this.members.forEach(t -> this.remove(remove, (VRObject)t));
                this.sendRemove(remove);
                this.sendAdd(add);
                this.oldPos.copy(this.client.getPosition());
                this.members = newScene;
                this.lastUpdate = System.currentTimeMillis();
            }
        }
        catch (Exception e) {
            log.error("Scene for " + this.client, (Throwable)e);
            throw e;
        }
        this.active = false;
    }

    private void add(VRObject t) {
        if (t.getChildren() != null) {
            for (VRObject obj : t.getChildren()) {
                if (!this.isVisible(obj)) continue;
                this.add(obj);
            }
        }
        if (t.isActive()) {
            t.addListener(this.client);
        }
        this.allObjects.put(new ID(t), t);
    }

    private void addPermanent(VRObject p) {
        if (p.isActive()) {
            p.addListener(this.client);
        }
        this.permanents.add(p);
        this.allObjects.put(new ID(p), p);
    }

    private boolean isInRange(VRObject o) {
        return o.getPosition() == null || o.getPosition().getX() == 0.0 && o.getPosition().getY() == 0.0 && o.getPosition().getZ() == 0.0 || o.getPosition().isInRange(this.client.getPosition(), this.props.getRange());
    }

    public void offer(VRObject o) {
        if (!this.members.contains(o) && this.isInRange(o) && this.isVisible(o)) {
            this.members.add(o);
            this.add(o);
            Add add = new Add().addObject(o);
            this.sendAdd(add);
        } else if (o.isPermanent() && !this.permanents.contains(o)) {
            this.addPermanent(o);
            this.sendAdd(new Add().addObject(o));
        }
    }

    public void offer(Collection<VRObject> objects) {
        Add add = new Add();
        for (VRObject o : objects) {
            log.debug("Client " + this.client.getId() + " offered " + o.getId() + " inRange:" + this.isInRange(o) + " visible:" + this.isVisible(o) + " contains:" + this.members.contains(o));
            if (!this.members.contains(o) && this.isInRange(o) && this.isVisible(o)) {
                this.members.add(o);
                this.add(o);
                add.addObject(o);
                continue;
            }
            if (!o.isPermanent() || this.permanents.contains(o)) continue;
            this.addPermanent(o);
            add.addObject(o);
        }
        this.sendAdd(add);
    }

    public void publishAll(Collection<VRObject> objects) {
        this.offer(objects);
        this.members.stream().filter(o -> o instanceof Client).forEach(o -> {
            Client c = (Client)o;
            if (c.getScene() != null) {
                c.getScene().offer(objects);
            }
        });
    }

    public void publish(VRObject obj) {
        this.offer(obj);
        this.members.stream().filter(o -> o instanceof Client).forEach(o -> {
            Client c = (Client)o;
            if (c.getScene() != null) {
                c.getScene().offer(obj);
            }
        });
    }

    public void unpublish(Collection<VRObject> objects) {
        Remove remove = new Remove();
        for (VRObject obj : objects) {
            this.remove(remove, obj);
        }
        this.sendRemove(remove);
        this.members.stream().filter(o -> o instanceof Client).forEach(o -> {
            Client c = (Client)o;
            if (c.getScene() != null) {
                Remove r = new Remove();
                for (VRObject obj : objects) {
                    c.getScene().remove(r, obj);
                }
                c.getScene().sendRemove(r);
            }
        });
    }

    public void unpublish(VRObject obj) {
        this.sendRemove(this.remove(new Remove(), obj));
        this.members.stream().filter(o -> o instanceof Client).forEach(o -> {
            Client c = (Client)o;
            if (c.getScene() != null) {
                Remove remove = c.getScene().remove(new Remove(), obj);
                c.getScene().sendRemove(remove);
            }
        });
    }

    public void logout(Client c) {
        if (this.members.contains(c)) {
            Remove remove = this.remove(new Remove(), c);
            this.sendRemove(remove);
        }
    }

    public void logout() {
        this.members.stream().filter(o -> o instanceof Client).forEach(o -> {
            Client c = (Client)o;
            if (c.getScene() != null) {
                c.getScene().logout(this.client);
            }
        });
    }

    public Scene dirty() {
        this.lastUpdate = 0L;
        return this;
    }

    private Remove remove(Remove remove, VRObject t) {
        if (this.members.contains(t) || this.allObjects.containsKey(t.getObjectId())) {
            if (t.getChildren() != null) {
                t.getChildren().forEach(obj -> this.remove(remove, (VRObject)obj));
            }
            remove.removeObject(t);
            t.removeListener(this.client);
            this.allObjects.remove(t.getObjectId());
            this.members.remove(t);
        }
        return remove;
    }

    public void removeAll() {
        Remove remove = new Remove();
        try {
            for (VRObject t : this.members) {
                this.remove(remove, t);
            }
            this.permanents.forEach(p -> p.removeListener(this.client));
            this.sendRemove(remove);
            this.dirty();
        }
        catch (Throwable e) {
            log.error("Error during removal", e);
        }
    }

    private void sendRemove(Remove remove) {
        log.debug("Scene for " + this.client.getId() + " removing " + remove.getObjects().size());
        if (remove.getObjects().size() > 0) {
            this.client.sendMessage(remove);
        }
    }

    private void sendAdd(Add add) {
        log.debug("Scene for " + this.client.getId() + " adding " + add.getObjects().size());
        if (add.getObjects().size() > 0) {
            this.client.sendMessage(add);
        }
    }

    protected boolean isVisible(VRObject o) {
        return !o.isDeleted() && !o.isPermanent() && !o.equals(this.client) && this.filters.values().stream().allMatch(f -> (Boolean)f.apply(o));
    }

    public VRObject get(ID id) {
        return this.allObjects.get(id);
    }

    public VRObject getClosest(double x, double y, double z) {
        Optional<VRObject> closestMember = this.members.stream().min(Comparator.comparing(t -> t.getPosition().getDistance(x, y, z)));
        return closestMember.get();
    }

    public void addFilter(String name, Filter filter) {
        this.filters.put(name, filter);
        this.dirty();
    }

    public void removeFilter(String name) {
        this.filters.remove(name);
        this.dirty();
    }
}

