/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vrspace.client.VRSpaceClient;
import org.vrspace.server.config.JacksonConfig;
import org.vrspace.server.dto.ClientRequest;
import org.vrspace.server.obj.Point;

public class StressTestClient {
    private static final Logger log = LoggerFactory.getLogger(StressTestClient.class);
    private int maxClients = 100;
    private long requestsPerSecondEach = 5L;
    private long initialDelay = 0L;
    private int runSeconds = 60;
    private String world = "template";
    private Point spawnPoint = new Point(0.0, 0.0, 0.0);
    private Double spawnRadius = this.maxClients / 2;
    private URI uri = URI.create("ws://localhost:8080/vrspace/client");
    private String avatarMesh = "/content/char/female/gracy_lee/scene.gltf";
    private List<VRSpaceClient> clients = new ArrayList<VRSpaceClient>(this.maxClients);
    private Status status = new Status();

    private void start() throws Exception {
        ObjectMapper objectMapper = new JacksonConfig().objectMapper();
        int threads = Runtime.getRuntime().availableProcessors() / 2;
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(threads);
        int i = 0;
        while (i < this.maxClients) {
            VRSpaceClient client = new VRSpaceClient(this.uri, objectMapper);
            String name = this.world + "-" + i;
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("name", name);
            params.put("mesh", this.avatarMesh);
            client.addErrorListener(s -> {
                this.status.errors.incrementAndGet();
                System.err.println(name + ": " + s);
            });
            client.connectAndEnterSync(this.world, params);
            client.addEventListener(e -> {
                this.status.requestsReceived.incrementAndGet();
                this.status.bytesReceived.addAndGet(e.getPayload().length());
            });
            long period = 1000L / this.requestsPerSecondEach;
            executor.scheduleAtFixedRate(new Sender(client), this.initialDelay, period, TimeUnit.MILLISECONDS);
            ++i;
        }
        if (this.runSeconds > 0) {
            Thread.sleep(this.runSeconds * 1000);
            executor.shutdownNow();
            executor.awaitTermination(1L, TimeUnit.SECONDS);
            Thread.sleep(1000L);
            this.clients.forEach(c -> c.disconnect());
            log.info("Done, " + String.valueOf(this.status));
            System.exit(0);
        }
    }

    public static void main(String[] args) throws Exception {
        new StressTestClient().start();
    }

    public class Sender
    implements Runnable {
        private VRSpaceClient client;
        private Point pos;

        public Sender(VRSpaceClient client) {
            this.pos = new Point(StressTestClient.this.spawnPoint.getX() + StressTestClient.this.spawnRadius * Math.random(), StressTestClient.this.spawnPoint.getY(), StressTestClient.this.spawnPoint.getZ() + StressTestClient.this.spawnRadius * Math.random());
            this.client = client;
        }

        @Override
        public void run() {
            ClientRequest req = new ClientRequest(this.client.getClient());
            req.addChange("position", new Point(this.randomPos(this.pos.getX()), this.randomPos(this.pos.getY()), this.randomPos(this.pos.getZ())));
            String payload = this.client.send(req);
            StressTestClient.this.status.requestsSent.incrementAndGet();
            StressTestClient.this.status.bytesSent.addAndGet(payload.length());
        }

        private Double randomPos(double pos) {
            return pos + Math.random();
        }
    }

    public class Status {
        public AtomicInteger requestsSent = new AtomicInteger();
        public AtomicLong bytesSent = new AtomicLong();
        public AtomicInteger requestsReceived = new AtomicInteger();
        public AtomicLong bytesReceived = new AtomicLong();
        public AtomicInteger errors = new AtomicInteger();

        public String toString() {
            return "Sent - requests: " + String.valueOf(this.requestsSent) + " bytes: " + String.valueOf(this.bytesSent) + " Received - requests: " + String.valueOf(this.requestsReceived) + " bytes: " + String.valueOf(this.bytesReceived) + " Errors: " + String.valueOf(this.errors);
        }
    }
}

