/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vrspace.server.dto.Add;
import org.vrspace.server.dto.ClientRequest;
import org.vrspace.server.dto.Command;
import org.vrspace.server.dto.Enter;
import org.vrspace.server.dto.Remove;
import org.vrspace.server.dto.SceneChange;
import org.vrspace.server.dto.Session;
import org.vrspace.server.dto.VREvent;
import org.vrspace.server.dto.Welcome;
import org.vrspace.server.obj.Client;

public class VRSpaceClient
implements WebSocket.Listener,
Runnable {
    private static final Logger log = LoggerFactory.getLogger(VRSpaceClient.class);
    private ObjectMapper mapper;
    private URI uri;
    private WebSocket ws;
    private List<Consumer<String>> messageListeners = new ArrayList<Consumer<String>>();
    private List<Consumer<Welcome>> welcomeListeners = new ArrayList<Consumer<Welcome>>();
    private List<Consumer<VREvent>> eventListeners = new ArrayList<Consumer<VREvent>>();
    private List<Consumer<SceneChange>> sceneListeners = new ArrayList<Consumer<SceneChange>>();
    private List<Consumer<String>> errorListeners = new ArrayList<Consumer<String>>();
    private StringBuilder text = new StringBuilder();
    private CountDownLatch welcomeLatch;
    private CountDownLatch commandLatch;
    private volatile Client client;
    private int errorCount = 0;
    private ScheduledFuture<?> reconnect;
    private String world = null;
    private volatile CompletableFuture<WebSocket> connecting;
    private volatile CompletableFuture<WebSocket> sending;
    private volatile boolean reconnectOnClose = true;
    private Map<String, String> settings = null;
    public static final long TIMEOUT = 5000L;
    public static final long RETRY = 10000L;

    public VRSpaceClient(URI uri, ObjectMapper mapper) {
        this.uri = uri;
        this.mapper = mapper;
    }

    public CompletableFuture<WebSocket> connect() {
        this.welcomeLatch = new CountDownLatch(1);
        this.connecting = new CompletableFuture();
        this.reconnect = Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate(this, 0L, 10000L, TimeUnit.MILLISECONDS);
        return this.connecting;
    }

    public void startSession() {
        this.commandLatch = new CountDownLatch(1);
        this.send(new Session());
        this.await(this.commandLatch);
    }

    public void connectAndEnter(String world) {
        this.connectAndEnterSync(world, this.settings);
    }

    public void disconnect() {
        this.reconnectOnClose = false;
        this.ws.sendClose(1000, "bye");
    }

    @Override
    public void run() {
        ((CompletableFuture)((CompletableFuture)HttpClient.newHttpClient().newWebSocketBuilder().connectTimeout(Duration.ofMillis(5000L)).buildAsync(this.uri, this).thenApply(ws -> {
            this.ws = ws;
            this.reconnect.cancel(true);
            this.connecting.complete((WebSocket)ws);
            return ws;
        })).handle((ws, exception) -> {
            if (exception != null) {
                log.error("Websocket exception connecting to " + String.valueOf(this.uri) + " - " + String.valueOf(exception));
            }
            return null;
        })).join();
    }

    public void connectAndEnterAsync(String world, Map<String, String> params) {
        this.connect().thenApply(ws -> {
            this.await(this.welcomeLatch);
            if (params != null) {
                this.settings = params;
                ClientRequest settings = new ClientRequest(this.getClient());
                params.entrySet().forEach(e -> {
                    VREvent vREvent = settings.addChange((String)e.getKey(), e.getValue());
                });
                this.send(settings);
            }
            this.enterSync(world);
            this.startSession();
            return ws;
        });
    }

    public void connectAndEnterSync(String world, Map<String, String> params) {
        try {
            this.connect().get();
            this.await(this.welcomeLatch);
            if (params != null) {
                this.settings = params;
                ClientRequest settings = new ClientRequest(this.getClient());
                params.entrySet().forEach(e -> {
                    VREvent vREvent = settings.addChange((String)e.getKey(), e.getValue());
                });
                this.send(settings);
            }
            this.enterSync(world);
            this.startSession();
        }
        catch (Exception e2) {
            log.error("Can't connect", (Throwable)e2);
        }
    }

    public VRSpaceClient addEventListener(Consumer<VREvent> listener) {
        this.eventListeners.add(listener);
        return this;
    }

    public VRSpaceClient addSceneListener(Consumer<SceneChange> listener) {
        this.sceneListeners.add(listener);
        return this;
    }

    public VRSpaceClient addErrorListener(Consumer<String> listener) {
        this.errorListeners.add(listener);
        return this;
    }

    public VRSpaceClient addMessageListener(Consumer<String> listener) {
        this.messageListeners.add(listener);
        return this;
    }

    public VRSpaceClient addWelcomeListener(Consumer<Welcome> listener) {
        this.welcomeListeners.add(listener);
        return this;
    }

    public void await(CountDownLatch latch) {
        try {
            long time = System.currentTimeMillis();
            latch.await();
            log.debug("Waited " + (System.currentTimeMillis() - time) + " ms");
        }
        catch (InterruptedException e) {
            log.error("Unexpected interrupt: ", (Throwable)e);
        }
    }

    public Client getClient() {
        return this.client;
    }

    public void enterSync(String world) {
        this.welcomeLatch = new CountDownLatch(1);
        this.send(new Enter(world));
        this.await(this.welcomeLatch);
        this.world = world;
    }

    public void enterAsync(String world) {
        this.send(new Enter(world));
        this.world = world;
    }

    public void send(String arg) {
        this.ws.sendText(arg, true);
    }

    public String send(ClientRequest req) {
        try {
            String text = this.mapper.writeValueAsString((Object)req);
            log.debug("Sending " + text);
            if (this.sending != null) {
                this.sending.join();
            }
            this.sending = this.ws.sendText(text, true);
            this.sending.exceptionally(err -> {
                log.error("Send error", err);
                return this.ws;
            });
            return text;
        }
        catch (Exception e) {
            log.error("OOPS", (Throwable)e);
            return "";
        }
    }

    public void send(Command cmd) {
        ClientRequest req = new ClientRequest(this.client, cmd);
        this.send(req);
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    @Override
    public void onOpen(WebSocket webSocket) {
        log.info("Connected to " + String.valueOf(this.uri));
        WebSocket.Listener.super.onOpen(webSocket);
    }

    @Override
    public CompletionStage<?> onText(WebSocket webSocket, CharSequence data, boolean last) {
        log.debug("Received " + last + ":" + String.valueOf(data));
        this.text.append(data);
        if (last) {
            String message = this.text.toString();
            this.messageListeners.forEach(l -> l.accept(message));
            this.text = new StringBuilder();
            try {
                if (message.startsWith("{\"Welcome\":{")) {
                    Welcome welcome = (Welcome)this.mapper.readValue(message, Welcome.class);
                    this.client = welcome.getClient();
                    this.welcomeLatch.countDown();
                    this.welcomeListeners.forEach(l -> l.accept(welcome));
                } else if (message.startsWith("{\"Add\":{\"")) {
                    Add add = (Add)this.mapper.readValue(message, Add.class);
                    this.sceneListeners.forEach(l -> l.accept(add));
                } else if (message.startsWith("{\"Remove\":{\"")) {
                    Remove remove = (Remove)this.mapper.readValue(message, Remove.class);
                    this.sceneListeners.forEach(l -> l.accept(remove));
                } else if (message.startsWith("{\"response\":")) {
                    this.commandLatch.countDown();
                } else if (message.startsWith("{\"ERROR\"")) {
                    ++this.errorCount;
                    this.errorListeners.forEach(l -> l.accept(message));
                } else {
                    VREvent event = (VREvent)this.mapper.readValue(message, VREvent.class);
                    event.setPayload(message);
                    this.eventListeners.forEach(l -> l.accept(event));
                }
            }
            catch (Exception e) {
                log.error("Message parsing or processing error", (Throwable)e);
            }
        }
        CompletionStage<?> ret = WebSocket.Listener.super.onText(webSocket, data, last);
        return ret;
    }

    @Override
    public void onError(WebSocket webSocket, Throwable error) {
        log.error("Websocket error " + String.valueOf(webSocket));
        this.connectAndEnter(this.world);
        WebSocket.Listener.super.onError(webSocket, error);
    }

    @Override
    public CompletionStage<?> onPing(WebSocket webSocket, ByteBuffer message) {
        return WebSocket.Listener.super.onPing(webSocket, message);
    }

    @Override
    public CompletionStage<?> onClose(WebSocket webSocket, int statusCode, String reason) {
        log.debug("Socket closed: " + statusCode + " " + reason);
        if (this.reconnectOnClose) {
            this.connectAndEnter(this.world);
        }
        return WebSocket.Listener.super.onClose(webSocket, statusCode, reason);
    }
}

