/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.api;

import jakarta.servlet.http.HttpSession;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.vrspace.server.api.ClientControllerBase;
import org.vrspace.server.core.GroupManager;
import org.vrspace.server.obj.Client;
import org.vrspace.server.obj.GroupMember;
import org.vrspace.server.obj.GroupMessage;
import org.vrspace.server.obj.UserGroup;

@RestController
@RequestMapping(value={"/vrspace/api/groups"})
public class Groups
extends ClientControllerBase {
    private static final Logger log = LoggerFactory.getLogger(Groups.class);
    public static final String PATH = "/vrspace/api/groups";
    @Autowired
    GroupManager groupManager;

    @GetMapping
    @ResponseBody
    public List<UserGroup> listMyGroups(HttpSession session) {
        Client client = this.getAuthorisedClient(session);
        log.debug("Group list, user: " + String.valueOf(client));
        return this.groupManager.listGroups(client);
    }

    @GetMapping(value={"/owned"})
    @ResponseBody
    public List<UserGroup> listOwnedGroups(HttpSession session) {
        Client client = this.getAuthorisedClient(session);
        log.debug("Group list, owner: " + String.valueOf(client));
        return this.groupManager.listOwnedGroups(client);
    }

    @PostMapping(produces={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public UserGroup create(String name, Optional<Boolean> isPublic, Optional<Boolean> isTemporary, HttpSession session) {
        Client client = this.getAuthorisedClient(session);
        log.debug("Group create, user: " + String.valueOf(client) + " group: " + name + " public: " + String.valueOf(isPublic) + " temporary: " + String.valueOf(isTemporary));
        return this.groupManager.createGroup(client, new UserGroup(name, isPublic.isPresent() && isPublic.get() != false, isTemporary.isPresent() && isTemporary.get() != false));
    }

    @PutMapping(produces={"application/json"})
    public void update(@RequestBody UserGroup group, HttpSession session) {
        Client client = this.getAuthorisedClient(session);
        log.debug("Group update, user: " + String.valueOf(client) + " group: " + String.valueOf(group));
        this.groupManager.updateGroup(client, group);
    }

    @DeleteMapping(value={"/{groupId}"})
    public void deleteGroup(@PathVariable long groupId, HttpSession session) {
        Client client = this.getAuthorisedClient(session);
        UserGroup group = this.groupManager.getGroup(client, groupId);
        log.debug("Group delete, user: " + String.valueOf(client) + " group: " + String.valueOf(group));
        this.groupManager.deleteGroup(client, group);
    }

    @GetMapping(value={"/{groupId}/show"})
    public List<Client> show(@PathVariable long groupId, HttpSession session) {
        Client client = this.getAuthorisedClient(session);
        UserGroup group = this.groupManager.getGroup(client, groupId);
        log.debug("Group show, user: " + String.valueOf(client) + " group: " + String.valueOf(group));
        return this.groupManager.show(group);
    }

    @PostMapping(value={"/{groupId}/join"})
    public void join(@PathVariable long groupId, HttpSession session) {
        Client client = this.getAuthorisedClient(session);
        UserGroup group = this.groupManager.getGroup(groupId);
        log.debug("Group join, user: " + String.valueOf(client) + " group: " + String.valueOf(group));
        this.groupManager.join(group, client);
    }

    @PostMapping(value={"/{groupId}/invite"})
    public void invite(@PathVariable long groupId, Long clientId, HttpSession session) {
        Client client = this.getAuthorisedClient(session);
        UserGroup group = this.groupManager.getGroup(client, groupId);
        log.debug("Group invite, user: " + String.valueOf(client) + " group: " + String.valueOf(group) + " invited: " + String.valueOf(clientId));
        this.groupManager.invite(group, clientId, client);
    }

    @PostMapping(value={"/{groupId}/ask"})
    public void ask(@PathVariable long groupId, HttpSession session) {
        Client client = this.getAuthorisedClient(session);
        UserGroup group = this.groupManager.getGroup(groupId);
        log.debug("Group ask, user: " + String.valueOf(client) + " group: " + String.valueOf(group));
        this.groupManager.ask(group, client);
    }

    @PostMapping(value={"/{groupId}/accept"})
    public void accept(@PathVariable long groupId, HttpSession session) {
        Client client = this.getAuthorisedClient(session);
        UserGroup group = this.groupManager.getGroup(client, groupId);
        log.debug("Group accept, user: " + String.valueOf(client) + " group: " + String.valueOf(group));
        this.groupManager.accept(group, client);
    }

    @PostMapping(value={"/{groupId}/allow"})
    public void allow(@PathVariable long groupId, long clientId, HttpSession session) {
        Client client = this.getAuthorisedClient(session);
        UserGroup group = this.groupManager.getGroup(client, groupId);
        log.debug("Group allow, user: " + String.valueOf(client) + " group: " + String.valueOf(group));
        this.groupManager.allow(group, clientId, client);
    }

    @PostMapping(value={"/{groupId}/leave"})
    public void leave(@PathVariable long groupId, HttpSession session) {
        Client client = this.getAuthorisedClient(session);
        UserGroup group = this.groupManager.getGroup(client, groupId);
        log.debug("Group leave, user: " + String.valueOf(client) + " group: " + String.valueOf(group));
        this.groupManager.leave(group, client);
    }

    @PostMapping(value={"/{groupId}/kick"})
    public void kick(@PathVariable long groupId, long clientId, HttpSession session) {
        Client client = this.getAuthorisedClient(session);
        UserGroup group = this.groupManager.getGroup(client, groupId);
        log.debug("Group kick, user: " + String.valueOf(client) + " group: " + String.valueOf(group));
        this.groupManager.kick(group, clientId, client);
    }

    @PostMapping(value={"/{groupId}/write"})
    public void write(@PathVariable long groupId, @RequestBody String text, HttpSession session) {
        Client client = this.getAuthorisedClient(session);
        UserGroup group = this.groupManager.getGroup(client, groupId);
        log.debug("Group write, user: " + String.valueOf(client) + " group: " + String.valueOf(group) + " text: " + text);
        this.groupManager.write(client, group, text);
    }

    @PostMapping(value={"/{groupId}/share"})
    public void shareWorld(@PathVariable long groupId, @RequestBody GroupMessage worldLink, HttpSession session) {
        Client client = this.getAuthorisedClient(session);
        UserGroup group = this.groupManager.getGroup(client, groupId);
        log.debug("Group share world, user: " + String.valueOf(client) + " group: " + String.valueOf(group) + " worldLink: " + String.valueOf(worldLink));
        this.groupManager.worldInvite(client, group, worldLink.getContent(), worldLink.getLink());
    }

    @GetMapping(value={"/{groupId}/requests"})
    public List<GroupMember> listRequests(@PathVariable long groupId, HttpSession session) {
        Client client = this.getAuthorisedClient(session);
        UserGroup group = this.groupManager.getGroup(client, groupId);
        log.debug("Group requests, user: " + String.valueOf(client) + " group: " + String.valueOf(group));
        return this.groupManager.pendingRequests(group, client);
    }

    @GetMapping(value={"/invitations"})
    public List<GroupMember> listInvites(HttpSession session) {
        Client client = this.getAuthorisedClient(session);
        log.debug("Group invites, user: " + String.valueOf(client));
        return this.groupManager.pendingInvitations(client);
    }

    @GetMapping(value={"/unread"})
    public List<UserGroup> listUnreadGroups(HttpSession session) {
        Client client = this.getAuthorisedClient(session);
        log.debug("Unread groups, user: " + String.valueOf(client));
        return this.groupManager.unreadGroups(client);
    }

    @GetMapping(value={"/{groupId}/unread"})
    public List<GroupMessage> listUnreadMessages(@PathVariable long groupId, HttpSession session) {
        Client client = this.getAuthorisedClient(session);
        UserGroup group = this.groupManager.getGroup(client, groupId);
        log.debug("Unread messages, user: " + String.valueOf(client) + " group: " + String.valueOf(group));
        return this.groupManager.unreadMessages(client, group);
    }

    @GetMapping(value={"/{groupId}/owners"})
    public List<Client> listOwners(@PathVariable long groupId, HttpSession session) {
        Client client = this.getAuthorisedClient(session);
        UserGroup group = this.groupManager.getGroup(client, groupId);
        log.debug("Unread messages, user: " + String.valueOf(client) + " group: " + String.valueOf(group));
        return this.groupManager.listOwners(group);
    }
}

