/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.api;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.vrspace.server.api.ApiBase;
import org.vrspace.server.api.Oauth2Login;
import org.vrspace.server.api.Sketchfab;
import org.vrspace.server.api.WebPush;
import org.vrspace.server.config.ServerConfig;
import org.vrspace.server.core.StreamManager;

@RestController
@RequestMapping(value={"/vrspace/api/server-info"})
public class ServerInfo
extends ApiBase {
    private static final Logger log = LoggerFactory.getLogger(ServerInfo.class);
    public static final String PATH = "/vrspace/api/server-info";
    @Autowired
    private ServerConfig config;
    @Autowired(required=false)
    private Oauth2Login oauth2Login;
    @Autowired
    private StreamManager streamManager;
    @Autowired
    private Sketchfab sketchfab;
    @Autowired(required=false)
    private WebPush webPush;
    @Value(value="${org.vrspace.server.socketPath:/vrspace/client}")
    private String clientPath;
    @Value(value="${org.vrspace.server.socketPath:/vrspace/server}")
    private String serverPath;
    @Value(value="${server.servlet.session.timeout:default}")
    private String sessionTimeout;

    @GetMapping
    public CapabilitiesAndConfig getServerInfo() {
        CapabilitiesAndConfig ret = new CapabilitiesAndConfig();
        ret.config = this.getServerConfig();
        ret.capabilities = this.getServerCapabilities();
        return ret;
    }

    @GetMapping(value={"/capabilities"})
    public ServerCapabilities getServerCapabilities() {
        ServerCapabilities ret = new ServerCapabilities();
        ret.setOauth2(this.oauth2Login != null);
        ret.setRemoteBrowser(this.config.isSeleniumEnabled());
        ret.setStreamingMedia(this.streamManager.isAvailable());
        ret.setSketchfab(this.sketchfab.isAvailable());
        ret.setWebPush(this.webPush != null);
        return ret;
    }

    @GetMapping(value={"/configuration"})
    public ServerConfiguration getServerConfig() {
        ServerConfiguration ret = new ServerConfiguration();
        ret.setGuestAllowed(this.config.isGuestAllowed());
        ret.setCreateWorlds(this.config.isCreateWorlds());
        ret.setMaxSessions(this.config.getMaxSessions());
        ret.setSessionStartTimeout(this.config.getSessionStartTimeout());
        ret.setSessionTimeout(this.sessionTimeout);
        ret.setWebSocketClientPath(this.clientPath);
        ret.setWebSocketServerPath(this.serverPath);
        return ret;
    }

    public static class CapabilitiesAndConfig {
        private ServerCapabilities capabilities;
        private ServerConfiguration config;

        @Generated
        public ServerCapabilities getCapabilities() {
            return this.capabilities;
        }

        @Generated
        public ServerConfiguration getConfig() {
            return this.config;
        }

        @Generated
        public void setCapabilities(ServerCapabilities capabilities) {
            this.capabilities = capabilities;
        }

        @Generated
        public void setConfig(ServerConfiguration config) {
            this.config = config;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CapabilitiesAndConfig)) {
                return false;
            }
            CapabilitiesAndConfig other = (CapabilitiesAndConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ServerCapabilities this$capabilities = this.getCapabilities();
            ServerCapabilities other$capabilities = other.getCapabilities();
            if (this$capabilities == null ? other$capabilities != null : !((Object)this$capabilities).equals(other$capabilities)) {
                return false;
            }
            ServerConfiguration this$config = this.getConfig();
            ServerConfiguration other$config = other.getConfig();
            return !(this$config == null ? other$config != null : !((Object)this$config).equals(other$config));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CapabilitiesAndConfig;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ServerCapabilities $capabilities = this.getCapabilities();
            result = result * 59 + ($capabilities == null ? 43 : ((Object)$capabilities).hashCode());
            ServerConfiguration $config = this.getConfig();
            result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ServerInfo.CapabilitiesAndConfig(capabilities=" + String.valueOf(this.getCapabilities()) + ", config=" + String.valueOf(this.getConfig()) + ")";
        }

        @Generated
        public CapabilitiesAndConfig() {
        }
    }

    public static class ServerCapabilities {
        private boolean oauth2;
        private boolean remoteBrowser;
        private boolean streamingMedia;
        private boolean sketchfab;
        private boolean webPush;

        @Generated
        public boolean isOauth2() {
            return this.oauth2;
        }

        @Generated
        public boolean isRemoteBrowser() {
            return this.remoteBrowser;
        }

        @Generated
        public boolean isStreamingMedia() {
            return this.streamingMedia;
        }

        @Generated
        public boolean isSketchfab() {
            return this.sketchfab;
        }

        @Generated
        public boolean isWebPush() {
            return this.webPush;
        }

        @Generated
        public void setOauth2(boolean oauth2) {
            this.oauth2 = oauth2;
        }

        @Generated
        public void setRemoteBrowser(boolean remoteBrowser) {
            this.remoteBrowser = remoteBrowser;
        }

        @Generated
        public void setStreamingMedia(boolean streamingMedia) {
            this.streamingMedia = streamingMedia;
        }

        @Generated
        public void setSketchfab(boolean sketchfab) {
            this.sketchfab = sketchfab;
        }

        @Generated
        public void setWebPush(boolean webPush) {
            this.webPush = webPush;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ServerCapabilities)) {
                return false;
            }
            ServerCapabilities other = (ServerCapabilities)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isOauth2() != other.isOauth2()) {
                return false;
            }
            if (this.isRemoteBrowser() != other.isRemoteBrowser()) {
                return false;
            }
            if (this.isStreamingMedia() != other.isStreamingMedia()) {
                return false;
            }
            if (this.isSketchfab() != other.isSketchfab()) {
                return false;
            }
            return this.isWebPush() == other.isWebPush();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ServerCapabilities;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isOauth2() ? 79 : 97);
            result = result * 59 + (this.isRemoteBrowser() ? 79 : 97);
            result = result * 59 + (this.isStreamingMedia() ? 79 : 97);
            result = result * 59 + (this.isSketchfab() ? 79 : 97);
            result = result * 59 + (this.isWebPush() ? 79 : 97);
            return result;
        }

        @Generated
        public String toString() {
            return "ServerInfo.ServerCapabilities(oauth2=" + this.isOauth2() + ", remoteBrowser=" + this.isRemoteBrowser() + ", streamingMedia=" + this.isStreamingMedia() + ", sketchfab=" + this.isSketchfab() + ", webPush=" + this.isWebPush() + ")";
        }

        @Generated
        public ServerCapabilities() {
        }
    }

    public static class ServerConfiguration {
        private boolean guestAllowed;
        private boolean createWorlds;
        private int maxSessions;
        private int sessionStartTimeout;
        private String sessionTimeout;
        private String webSocketClientPath;
        private String webSocketServerPath;

        @Generated
        public boolean isGuestAllowed() {
            return this.guestAllowed;
        }

        @Generated
        public boolean isCreateWorlds() {
            return this.createWorlds;
        }

        @Generated
        public int getMaxSessions() {
            return this.maxSessions;
        }

        @Generated
        public int getSessionStartTimeout() {
            return this.sessionStartTimeout;
        }

        @Generated
        public String getSessionTimeout() {
            return this.sessionTimeout;
        }

        @Generated
        public String getWebSocketClientPath() {
            return this.webSocketClientPath;
        }

        @Generated
        public String getWebSocketServerPath() {
            return this.webSocketServerPath;
        }

        @Generated
        public void setGuestAllowed(boolean guestAllowed) {
            this.guestAllowed = guestAllowed;
        }

        @Generated
        public void setCreateWorlds(boolean createWorlds) {
            this.createWorlds = createWorlds;
        }

        @Generated
        public void setMaxSessions(int maxSessions) {
            this.maxSessions = maxSessions;
        }

        @Generated
        public void setSessionStartTimeout(int sessionStartTimeout) {
            this.sessionStartTimeout = sessionStartTimeout;
        }

        @Generated
        public void setSessionTimeout(String sessionTimeout) {
            this.sessionTimeout = sessionTimeout;
        }

        @Generated
        public void setWebSocketClientPath(String webSocketClientPath) {
            this.webSocketClientPath = webSocketClientPath;
        }

        @Generated
        public void setWebSocketServerPath(String webSocketServerPath) {
            this.webSocketServerPath = webSocketServerPath;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ServerConfiguration)) {
                return false;
            }
            ServerConfiguration other = (ServerConfiguration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isGuestAllowed() != other.isGuestAllowed()) {
                return false;
            }
            if (this.isCreateWorlds() != other.isCreateWorlds()) {
                return false;
            }
            if (this.getMaxSessions() != other.getMaxSessions()) {
                return false;
            }
            if (this.getSessionStartTimeout() != other.getSessionStartTimeout()) {
                return false;
            }
            String this$sessionTimeout = this.getSessionTimeout();
            String other$sessionTimeout = other.getSessionTimeout();
            if (this$sessionTimeout == null ? other$sessionTimeout != null : !this$sessionTimeout.equals(other$sessionTimeout)) {
                return false;
            }
            String this$webSocketClientPath = this.getWebSocketClientPath();
            String other$webSocketClientPath = other.getWebSocketClientPath();
            if (this$webSocketClientPath == null ? other$webSocketClientPath != null : !this$webSocketClientPath.equals(other$webSocketClientPath)) {
                return false;
            }
            String this$webSocketServerPath = this.getWebSocketServerPath();
            String other$webSocketServerPath = other.getWebSocketServerPath();
            return !(this$webSocketServerPath == null ? other$webSocketServerPath != null : !this$webSocketServerPath.equals(other$webSocketServerPath));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ServerConfiguration;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isGuestAllowed() ? 79 : 97);
            result = result * 59 + (this.isCreateWorlds() ? 79 : 97);
            result = result * 59 + this.getMaxSessions();
            result = result * 59 + this.getSessionStartTimeout();
            String $sessionTimeout = this.getSessionTimeout();
            result = result * 59 + ($sessionTimeout == null ? 43 : $sessionTimeout.hashCode());
            String $webSocketClientPath = this.getWebSocketClientPath();
            result = result * 59 + ($webSocketClientPath == null ? 43 : $webSocketClientPath.hashCode());
            String $webSocketServerPath = this.getWebSocketServerPath();
            result = result * 59 + ($webSocketServerPath == null ? 43 : $webSocketServerPath.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ServerInfo.ServerConfiguration(guestAllowed=" + this.isGuestAllowed() + ", createWorlds=" + this.isCreateWorlds() + ", maxSessions=" + this.getMaxSessions() + ", sessionStartTimeout=" + this.getSessionStartTimeout() + ", sessionTimeout=" + this.getSessionTimeout() + ", webSocketClientPath=" + this.getWebSocketClientPath() + ", webSocketServerPath=" + this.getWebSocketServerPath() + ")";
        }

        @Generated
        public ServerConfiguration() {
        }
    }
}

