/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.api;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.vrspace.server.api.ClientControllerBase;
import org.vrspace.server.core.FileUtil;
import org.vrspace.server.obj.Client;
import org.vrspace.server.obj.Content;
import org.vrspace.server.obj.Point;
import org.vrspace.server.obj.Rotation;
import org.vrspace.server.obj.VRFile;
import org.vrspace.server.obj.VRObject;

@RestController
@RequestMapping(value={"/vrspace/api/files"})
public class SharedContent
extends ClientControllerBase {
    private static final Logger log = LoggerFactory.getLogger(SharedContent.class);
    public static final String PATH = "/vrspace/api/files";

    @PutMapping(value={"/upload"})
    public void upload(HttpSession session, HttpServletRequest request, String fileName, String contentType, Double x, Double y, Double z, Double rotX, Double rotY, Double rotZ, @RequestPart MultipartFile fileData) throws IOException {
        Client client = this.findClient(session);
        String path = FileUtil.uploadDir();
        Long fileSize = fileData.getSize();
        File dest = new File(path + File.separator + fileName);
        dest.mkdirs();
        log.debug("uploading " + contentType + "/" + fileData.getContentType() + " to " + String.valueOf(dest) + " size " + String.valueOf(fileSize) + " pos " + String.valueOf(x) + "," + String.valueOf(y) + "," + String.valueOf(z) + " rot " + String.valueOf(rotX) + "," + String.valueOf(rotY) + "," + String.valueOf(rotZ));
        try {
            Throwable throwable = null;
            Object var17_19 = null;
            try (InputStream inputStream = fileData.getInputStream();){
                Files.copy(inputStream, dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            log.error("Upload error", (Throwable)e);
        }
        VRObject obj = null;
        Content content = null;
        if (!"model/gltf+json".equals(contentType)) {
            if ("model/gltf-binary".equals(contentType)) {
                obj = new VRObject();
                obj.setMesh("/content/tmp/" + fileName);
                obj.setActive(true);
            } else {
                content = new Content();
                content.setFileName(fileName);
                content.setFolder(path);
                content.setContentType(contentType);
                content.setLength(fileSize);
                obj = new VRFile();
                ((VRFile)obj).setContent(content);
                obj.setActive(true);
            }
        }
        Point pos = null;
        Rotation rot = null;
        if (x != null & y != null & z != null) {
            pos = new Point(x, y, z);
        }
        if (rotX != null & rotY != null & rotZ != null) {
            rot = new Rotation(rotX, rotY, rotZ);
        }
        obj.setPosition(pos);
        obj.setRotation(rot);
        obj.setProperties(Map.of("clientId", client.getId()));
        this.worldManager.add(client, obj);
        client.getScene().publish(obj);
    }
}

