/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.api;

import jakarta.servlet.http.HttpSession;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.vrspace.server.api.ApiBase;
import org.vrspace.server.api.ApiException;
import org.vrspace.server.core.ClientFactory;
import org.vrspace.server.core.VRObjectRepository;
import org.vrspace.server.core.WorldManager;
import org.vrspace.server.dto.WorldStatus;
import org.vrspace.server.obj.Client;
import org.vrspace.server.obj.World;

@RestController
@RequestMapping(value={"/vrspace/api/worlds"})
public class Worlds
extends ApiBase {
    private static final Logger log = LoggerFactory.getLogger(Worlds.class);
    public static final String PATH = "/vrspace/api/worlds";
    @Autowired
    private VRObjectRepository db;
    @Autowired
    private ClientFactory clientFactory;
    @Autowired
    private WorldManager manager;

    @GetMapping(value={"/list"})
    public List<World> list() {
        List<World> worlds = this.db.listWorlds();
        log.debug("Worlds: " + String.valueOf(worlds));
        return worlds;
    }

    @GetMapping(value={"/users"})
    public List<WorldStatus> users() {
        List<WorldStatus> stats = this.db.countUsers();
        log.debug("Stats: " + String.valueOf(stats));
        return stats;
    }

    @PostMapping(value={"/create"})
    public ResponseEntity<String> createWorld(HttpSession session, @RequestBody(required=true) CreateWorldOptions params) {
        String userName = Worlds.currentUserName(session, this.clientFactory);
        log.debug("Create world, user: " + userName + " parms: " + String.valueOf(params));
        if (userName == null) {
            throw new SecurityException("User must be logged in");
        }
        Client user = this.manager.getClientByName(userName);
        if (user == null) {
            throw new SecurityException("User " + userName + " must be logged in");
        }
        if (params.worldName == null) {
            throw new ApiException("World name must be specified");
        }
        UUID token = null;
        token = params.token == null ? UUID.randomUUID() : UUID.fromString(params.token);
        World world = this.db.getWorldByName(params.worldName);
        if (world == null) {
            world = new World();
            String cfr_ignored_0 = params.templateName;
            world.setName(params.worldName);
            world.setOwner(user);
            world.setDefaultWorld(false);
            world.setPublicWorld(params.publicWorld);
            world.setTemporaryWorld(params.temporaryWorld);
            if (!params.publicWorld) {
                world.setToken(token.toString());
            }
            world = this.manager.saveWorld(world);
            log.info("World " + params.worldName + " created by user " + userName + " token: " + world.getToken());
            return new ResponseEntity((Object)world.getToken(), (HttpStatusCode)HttpStatus.CREATED);
        }
        if (!user.equals((world = (World)this.db.get(World.class, world.getId())).getOwner())) {
            throw new SecurityException("User " + userName + " does not own exiting world " + params.worldName);
        }
        world.setPublicWorld(params.publicWorld);
        world.setTemporaryWorld(params.temporaryWorld);
        if (params.publicWorld) {
            world.setToken(null);
        } else {
            world.setToken(token.toString());
        }
        log.info("World " + params.worldName + " updated by user " + userName + " token: " + world.getToken());
        return new ResponseEntity((Object)world.getToken(), (HttpStatusCode)HttpStatus.OK);
    }

    public static class CreateWorldOptions {
        @NonNull
        private String worldName;
        private String templateName;
        private String token;
        private boolean publicWorld;
        private boolean temporaryWorld = true;

        @NonNull
        @Generated
        public String getWorldName() {
            return this.worldName;
        }

        @Generated
        public String getTemplateName() {
            return this.templateName;
        }

        @Generated
        public String getToken() {
            return this.token;
        }

        @Generated
        public boolean isPublicWorld() {
            return this.publicWorld;
        }

        @Generated
        public boolean isTemporaryWorld() {
            return this.temporaryWorld;
        }

        @Generated
        public void setWorldName(@NonNull String worldName) {
            if (worldName == null) {
                throw new NullPointerException("worldName is marked non-null but is null");
            }
            this.worldName = worldName;
        }

        @Generated
        public void setTemplateName(String templateName) {
            this.templateName = templateName;
        }

        @Generated
        public void setToken(String token) {
            this.token = token;
        }

        @Generated
        public void setPublicWorld(boolean publicWorld) {
            this.publicWorld = publicWorld;
        }

        @Generated
        public void setTemporaryWorld(boolean temporaryWorld) {
            this.temporaryWorld = temporaryWorld;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CreateWorldOptions)) {
                return false;
            }
            CreateWorldOptions other = (CreateWorldOptions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isPublicWorld() != other.isPublicWorld()) {
                return false;
            }
            if (this.isTemporaryWorld() != other.isTemporaryWorld()) {
                return false;
            }
            String this$worldName = this.getWorldName();
            String other$worldName = other.getWorldName();
            if (this$worldName == null ? other$worldName != null : !this$worldName.equals(other$worldName)) {
                return false;
            }
            String this$templateName = this.getTemplateName();
            String other$templateName = other.getTemplateName();
            if (this$templateName == null ? other$templateName != null : !this$templateName.equals(other$templateName)) {
                return false;
            }
            String this$token = this.getToken();
            String other$token = other.getToken();
            return !(this$token == null ? other$token != null : !this$token.equals(other$token));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof CreateWorldOptions;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isPublicWorld() ? 79 : 97);
            result = result * 59 + (this.isTemporaryWorld() ? 79 : 97);
            String $worldName = this.getWorldName();
            result = result * 59 + ($worldName == null ? 43 : $worldName.hashCode());
            String $templateName = this.getTemplateName();
            result = result * 59 + ($templateName == null ? 43 : $templateName.hashCode());
            String $token = this.getToken();
            result = result * 59 + ($token == null ? 43 : $token.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "Worlds.CreateWorldOptions(worldName=" + this.getWorldName() + ", templateName=" + this.getTemplateName() + ", token=" + this.getToken() + ", publicWorld=" + this.isPublicWorld() + ", temporaryWorld=" + this.isTemporaryWorld() + ")";
        }

        @Generated
        public CreateWorldOptions() {
        }

        @Generated
        public CreateWorldOptions(@NonNull String worldName, String templateName, String token, boolean publicWorld, boolean temporaryWorld) {
            if (worldName == null) {
                throw new NullPointerException("worldName is marked non-null but is null");
            }
            this.worldName = worldName;
            this.templateName = templateName;
            this.token = token;
            this.publicWorld = publicWorld;
            this.temporaryWorld = temporaryWorld;
        }
    }
}

