/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.vrspace.server.obj.Point;
import org.vrspace.server.obj.Rotation;

@Configuration
@ConfigurationProperties(value="org.vrspace.server")
public class BotConfig {
    private static final Logger log = LoggerFactory.getLogger(BotConfig.class);
    private Map<String, BotProperties> bot = new HashMap<String, BotProperties>();

    @Generated
    public Map<String, BotProperties> getBot() {
        return this.bot;
    }

    @Generated
    public void setBot(Map<String, BotProperties> bot) {
        this.bot = bot;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BotConfig)) {
            return false;
        }
        BotConfig other = (BotConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, BotProperties> this$bot = this.getBot();
        Map<String, BotProperties> other$bot = other.getBot();
        return !(this$bot == null ? other$bot != null : !((Object)this$bot).equals(other$bot));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BotConfig;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, BotProperties> $bot = this.getBot();
        result = result * 59 + ($bot == null ? 43 : ((Object)$bot).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BotConfig(bot=" + String.valueOf(this.getBot()) + ")";
    }

    @Generated
    public BotConfig() {
    }

    public static class BotProperties {
        private String type;
        private String name;
        private String url;
        private String world;
        private String mesh;
        private String gender;
        private String lang;
        private Map<String, String> parameterMap;
        private List<Double> position;
        private List<Double> rotation;
        private List<Double> scale;
        private String params;

        public void setParams(String params) {
            ObjectMapper mapper = new ObjectMapper();
            try {
                this.params = params;
                this.parameterMap = (Map)mapper.readValue(params, Map.class);
            }
            catch (Exception e) {
                log.error("Can't read bot parameters " + params, (Throwable)e);
            }
        }

        public boolean hasPoint(List<Double> coord) {
            return coord != null && coord.size() >= 3;
        }

        public Point getPoint(List<Double> coord) {
            return new Point(coord.get(0), coord.get(1), coord.get(2));
        }

        public Rotation getRotation(List<Double> coord) {
            if (coord.size() > 3) {
                return new Rotation(coord.get(0), coord.get(1), coord.get(2), coord.get(3));
            }
            return new Rotation(coord.get(0), coord.get(1), coord.get(2), 0.0);
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getUrl() {
            return this.url;
        }

        @Generated
        public String getWorld() {
            return this.world;
        }

        @Generated
        public String getMesh() {
            return this.mesh;
        }

        @Generated
        public String getGender() {
            return this.gender;
        }

        @Generated
        public String getLang() {
            return this.lang;
        }

        @Generated
        public Map<String, String> getParameterMap() {
            return this.parameterMap;
        }

        @Generated
        public List<Double> getPosition() {
            return this.position;
        }

        @Generated
        public List<Double> getRotation() {
            return this.rotation;
        }

        @Generated
        public List<Double> getScale() {
            return this.scale;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setUrl(String url) {
            this.url = url;
        }

        @Generated
        public void setWorld(String world) {
            this.world = world;
        }

        @Generated
        public void setMesh(String mesh) {
            this.mesh = mesh;
        }

        @Generated
        public void setGender(String gender) {
            this.gender = gender;
        }

        @Generated
        public void setLang(String lang) {
            this.lang = lang;
        }

        @Generated
        public void setParameterMap(Map<String, String> parameterMap) {
            this.parameterMap = parameterMap;
        }

        @Generated
        public void setPosition(List<Double> position) {
            this.position = position;
        }

        @Generated
        public void setRotation(List<Double> rotation) {
            this.rotation = rotation;
        }

        @Generated
        public void setScale(List<Double> scale) {
            this.scale = scale;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BotProperties)) {
                return false;
            }
            BotProperties other = (BotProperties)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            String this$world = this.getWorld();
            String other$world = other.getWorld();
            if (this$world == null ? other$world != null : !this$world.equals(other$world)) {
                return false;
            }
            String this$mesh = this.getMesh();
            String other$mesh = other.getMesh();
            if (this$mesh == null ? other$mesh != null : !this$mesh.equals(other$mesh)) {
                return false;
            }
            String this$gender = this.getGender();
            String other$gender = other.getGender();
            if (this$gender == null ? other$gender != null : !this$gender.equals(other$gender)) {
                return false;
            }
            String this$lang = this.getLang();
            String other$lang = other.getLang();
            if (this$lang == null ? other$lang != null : !this$lang.equals(other$lang)) {
                return false;
            }
            Map<String, String> this$parameterMap = this.getParameterMap();
            Map<String, String> other$parameterMap = other.getParameterMap();
            if (this$parameterMap == null ? other$parameterMap != null : !((Object)this$parameterMap).equals(other$parameterMap)) {
                return false;
            }
            List<Double> this$position = this.getPosition();
            List<Double> other$position = other.getPosition();
            if (this$position == null ? other$position != null : !((Object)this$position).equals(other$position)) {
                return false;
            }
            List<Double> this$rotation = this.getRotation();
            List<Double> other$rotation = other.getRotation();
            if (this$rotation == null ? other$rotation != null : !((Object)this$rotation).equals(other$rotation)) {
                return false;
            }
            List<Double> this$scale = this.getScale();
            List<Double> other$scale = other.getScale();
            if (this$scale == null ? other$scale != null : !((Object)this$scale).equals(other$scale)) {
                return false;
            }
            String this$params = this.params;
            String other$params = other.params;
            return !(this$params == null ? other$params != null : !this$params.equals(other$params));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof BotProperties;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            String $world = this.getWorld();
            result = result * 59 + ($world == null ? 43 : $world.hashCode());
            String $mesh = this.getMesh();
            result = result * 59 + ($mesh == null ? 43 : $mesh.hashCode());
            String $gender = this.getGender();
            result = result * 59 + ($gender == null ? 43 : $gender.hashCode());
            String $lang = this.getLang();
            result = result * 59 + ($lang == null ? 43 : $lang.hashCode());
            Map<String, String> $parameterMap = this.getParameterMap();
            result = result * 59 + ($parameterMap == null ? 43 : ((Object)$parameterMap).hashCode());
            List<Double> $position = this.getPosition();
            result = result * 59 + ($position == null ? 43 : ((Object)$position).hashCode());
            List<Double> $rotation = this.getRotation();
            result = result * 59 + ($rotation == null ? 43 : ((Object)$rotation).hashCode());
            List<Double> $scale = this.getScale();
            result = result * 59 + ($scale == null ? 43 : ((Object)$scale).hashCode());
            String $params = this.params;
            result = result * 59 + ($params == null ? 43 : $params.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BotConfig.BotProperties(type=" + this.getType() + ", name=" + this.getName() + ", url=" + this.getUrl() + ", world=" + this.getWorld() + ", mesh=" + this.getMesh() + ", gender=" + this.getGender() + ", lang=" + this.getLang() + ", parameterMap=" + String.valueOf(this.getParameterMap()) + ", position=" + String.valueOf(this.getPosition()) + ", rotation=" + String.valueOf(this.getRotation()) + ", scale=" + String.valueOf(this.getScale()) + ", params=" + this.params + ")";
        }

        @Generated
        public BotProperties() {
        }
    }
}

