/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.config;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configurers.AuthorizeHttpRequestsConfigurer;
import org.springframework.security.config.annotation.web.configurers.oauth2.client.OAuth2LoginConfigurer;
import org.springframework.security.web.SecurityFilterChain;

@Configuration
@ConditionalOnProperty(value={"org.vrspace.oauth2.enabled"})
@EnableWebSecurity
public class WebSecurityConfig {
    public static final String ENDPOINT = "/vrspace/api/oauth2";

    @Bean
    SecurityFilterChain filterChain(HttpSecurity httpSecurity) throws Exception {
        httpSecurity.csrf(csrf -> {
            HttpSecurityBuilder httpSecurityBuilder = csrf.disable();
        });
        httpSecurity.authorizeHttpRequests(requests -> {
            AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)requests.requestMatchers(new String[]{"/vrspace/api/oauth2/login**"})).authenticated();
        });
        httpSecurity.oauth2Login(login -> {
            login.loginPage("/vrspace/api/oauth2/provider");
            login.authorizationEndpoint(config -> {
                OAuth2LoginConfigurer.AuthorizationEndpointConfig authorizationEndpointConfig = config.baseUri("/vrspace/api/oauth2/authorization");
            });
        });
        httpSecurity.authorizeHttpRequests(requests -> {
            AuthorizeHttpRequestsConfigurer.AuthorizationManagerRequestMatcherRegistry authorizationManagerRequestMatcherRegistry = ((AuthorizeHttpRequestsConfigurer.AuthorizedUrl)requests.requestMatchers(new String[]{"/**"})).permitAll();
        });
        return (SecurityFilterChain)httpSecurity.build();
    }
}

