/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.config;

import jakarta.servlet.http.HttpSession;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;
import org.springframework.web.socket.server.HandshakeInterceptor;
import org.springframework.web.socket.server.support.HttpSessionHandshakeInterceptor;
import org.vrspace.server.core.ServerSessionManager;
import org.vrspace.server.core.SessionManager;

@Configuration
@EnableWebSocket
public class WebSocketConfig
implements WebSocketConfigurer {
    @Value(value="${org.vrspace.server.socketPath:/vrspace/client}")
    private String clientPath;
    @Value(value="${org.vrspace.server.socketPath:/vrspace/server}")
    private String serverPath;
    @Value(value="${org.vrspace.server.allowedOrigins:*}")
    private String origins;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ServerSessionManager serverSessionManager;

    public void registerWebSocketHandlers(WebSocketHandlerRegistry registry) {
        registry.addHandler((WebSocketHandler)this.sessionManager, new String[]{this.clientPath}).setAllowedOrigins(new String[]{this.origins}).addInterceptors(new HandshakeInterceptor[]{new CustomSessionHandshakeInterceptor()});
        registry.addHandler((WebSocketHandler)this.serverSessionManager, new String[]{this.serverPath}).setAllowedOrigins(new String[]{this.origins}).addInterceptors(new HandshakeInterceptor[]{new CustomSessionHandshakeInterceptor()});
    }

    public class CustomSessionHandshakeInterceptor
    extends HttpSessionHandshakeInterceptor {
        public static final String HTTP_SESSION_ATTR_NAME = "HTTP.SESSION";

        public boolean beforeHandshake(ServerHttpRequest request, ServerHttpResponse response, WebSocketHandler wsHandler, Map<String, Object> attributes) throws Exception {
            boolean ret = super.beforeHandshake(request, response, wsHandler, attributes);
            if (request instanceof ServletServerHttpRequest) {
                ServletServerHttpRequest serverRequest = (ServletServerHttpRequest)request;
                HttpSession httpSession = serverRequest.getServletRequest().getSession(this.isCreateSession());
                attributes.put(HTTP_SESSION_ATTR_NAME, httpSession);
            }
            return ret;
        }
    }
}

