/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.connect;

import co.elastic.clients.elasticsearch.ElasticsearchAsyncClient;
import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._helpers.bulk.BulkIngester;
import co.elastic.clients.elasticsearch.core.IndexRequest;
import co.elastic.clients.elasticsearch.core.bulk.IndexOperation;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonTypeIdResolver;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.io.IOException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.message.BasicHeader;
import org.elasticsearch.client.RestClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;
import org.vrspace.server.core.CustomTypeIdResolver;
import org.vrspace.server.core.SessionListener;
import org.vrspace.server.dto.ClientRequest;
import org.vrspace.server.dto.Command;
import org.vrspace.server.dto.Enter;
import org.vrspace.server.dto.VREvent;
import org.vrspace.server.obj.Client;
import org.vrspace.server.obj.Ownership;
import org.vrspace.server.obj.VRObject;
import org.vrspace.server.obj.World;
import org.vrspace.server.types.ID;

@Component
@ConditionalOnProperty(value={"org.vrspace.server.session-listener.es.url"})
public class ElasticSearchSessionListener
implements SessionListener {
    private static final Logger log = LoggerFactory.getLogger(ElasticSearchSessionListener.class);
    @Value(value="${org.vrspace.server.session-listener.es.url}")
    private String url;
    @Value(value="${org.vrspace.server.session-listener.es.key}")
    private String apiKey;
    @Value(value="${org.vrspace.server.session-listener.es.index}")
    private String index;
    @Autowired
    @Qualifier(value="objectMapper")
    ObjectMapper objectMapper;
    private BulkIngester<?> ingester;

    @PostConstruct
    public void setup() {
        log.info("Session listener configured for " + this.url);
        RestClient restClient = RestClient.builder((HttpHost[])new HttpHost[]{HttpHost.create((String)this.url)}).setDefaultHeaders(new Header[]{new BasicHeader("Authorization", "ApiKey " + this.apiKey)}).build();
        RestClientTransport transport = new RestClientTransport(restClient, (JsonpMapper)new JacksonJsonpMapper(this.objectMapper));
        ElasticsearchClient esClient = new ElasticsearchClient((ElasticsearchTransport)transport);
        ESLogEntry entry = new ESLogEntry();
        entry.timestamp = LocalDateTime.now(ZoneId.of("UTC"));
        entry.duration = 0L;
        Client client = new Client(1L);
        VRObject object = new VRObject((Long)1L, new VRObject[0]);
        entry.source = new ID(object);
        entry.client = new ID(client);
        entry.world = new World();
        entry.world.setName("Test world");
        entry.world.setDefaultWorld(false);
        entry.ownership = new Ownership(client, object);
        Enter enter = new Enter();
        enter.setWorld(entry.world.getName());
        entry.command = enter;
        entry.connect = true;
        entry.error = new ESErrorMessage("VRSpace session connector starting up", new RuntimeException("Test exception"));
        entry.changes = new HashMap<String, Object>();
        entry.changes.put("url", "https://www.vrspace.org");
        try {
            Throwable throwable = null;
            Object var9_11 = null;
            try (ElasticsearchAsyncClient asyncClient = new ElasticsearchAsyncClient((ElasticsearchTransport)transport);){
                asyncClient.index(IndexRequest.of(i -> i.index(this.index).document((Object)entry))).whenComplete((response, exception) -> {
                    if (exception != null) {
                        log.error("Indexing error: ", exception);
                    }
                });
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            log.error("Error closing ES async client", (Throwable)e);
        }
        this.ingester = BulkIngester.of(b -> b.client(esClient).flushInterval(1L, TimeUnit.SECONDS));
    }

    @PreDestroy
    public void destroy() {
        log.info("Session listener disconnecting from " + this.url);
        this.ingester.close();
    }

    @Override
    public void success(ClientRequest request) {
        this.send(new ESLogEntry(request));
    }

    @Override
    public void event(VREvent event) {
        this.send(new ESLogEntry(event));
    }

    @Override
    public void failure(Client client, String message, Throwable error) {
        this.send(new ESLogEntry(client, message, error));
    }

    @Override
    public void login(Client client) {
        this.send(new ESLogEntry(client, true));
    }

    @Override
    public void logout(Client client) {
        this.send(new ESLogEntry(client, false));
        this.ingester.flush();
    }

    private void send(ESLogEntry entry) {
        this.ingester.add(op -> op.index(i -> ((IndexOperation.Builder)i.index(this.index)).document((Object)entry)));
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public class ESErrorMessage {
        private String message;
        private String stackTrace;

        public ESErrorMessage(String message, Throwable error) {
            this.message = message;
            if (error != null) {
                this.stackTrace = ExceptionUtils.getStackTrace((Throwable)error);
            }
        }

        @Generated
        public String getMessage() {
            return this.message;
        }

        @Generated
        public String getStackTrace() {
            return this.stackTrace;
        }

        @Generated
        public void setMessage(String message) {
            this.message = message;
        }

        @Generated
        public void setStackTrace(String stackTrace) {
            this.stackTrace = stackTrace;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ESErrorMessage)) {
                return false;
            }
            ESErrorMessage other = (ESErrorMessage)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            String this$stackTrace = this.getStackTrace();
            String other$stackTrace = other.getStackTrace();
            return !(this$stackTrace == null ? other$stackTrace != null : !this$stackTrace.equals(other$stackTrace));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ESErrorMessage;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            String $stackTrace = this.getStackTrace();
            result = result * 59 + ($stackTrace == null ? 43 : $stackTrace.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ElasticSearchSessionListener.ESErrorMessage(super=" + super.toString() + ", message=" + this.getMessage() + ", stackTrace=" + this.getStackTrace() + ")";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public class ESLogEntry {
        private Map<String, Object> changes;
        private LocalDateTime timestamp;
        private long duration;
        private ID source;
        private ID client;
        private World world;
        private Ownership ownership;
        @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.WRAPPER_OBJECT)
        @JsonTypeIdResolver(value=CustomTypeIdResolver.class)
        private Command command;
        private Boolean connect;
        private ESErrorMessage error;

        public ESLogEntry(ClientRequest request) {
            this((VREvent)request);
            this.command = request.getCommand();
        }

        public ESLogEntry(VREvent event) {
            this.changes = event.getChanges();
            this.timestamp = event.getTimestamp();
            this.duration = Duration.between(this.timestamp, LocalDateTime.now(ZoneId.of("UTC"))).toMillis();
            if (event.getSource() != null) {
                this.source = event.getSource().getObjectId();
            }
            if (event.getClient() != null) {
                this.client = event.getClient().getObjectId();
                this.world = event.getClient().getWorld();
            } else if (event.getSource() != null && event.getSource() instanceof Client) {
                this.world = ((Client)event.getSource()).getWorld();
            }
            this.ownership = event.getOwnership();
        }

        public ESLogEntry(Client client, Boolean connect) {
            this.client = client.getObjectId();
            this.world = client.getWorld();
            this.timestamp = LocalDateTime.now(ZoneId.of("UTC"));
            this.connect = connect;
        }

        public ESLogEntry(Client client, String message, Throwable error) {
            this.client = client.getObjectId();
            this.world = client.getWorld();
            this.timestamp = LocalDateTime.now(ZoneId.of("UTC"));
            this.error = new ESErrorMessage(message, error);
        }

        @Generated
        public Map<String, Object> getChanges() {
            return this.changes;
        }

        @Generated
        public LocalDateTime getTimestamp() {
            return this.timestamp;
        }

        @Generated
        public long getDuration() {
            return this.duration;
        }

        @Generated
        public ID getSource() {
            return this.source;
        }

        @Generated
        public ID getClient() {
            return this.client;
        }

        @Generated
        public World getWorld() {
            return this.world;
        }

        @Generated
        public Ownership getOwnership() {
            return this.ownership;
        }

        @Generated
        public Command getCommand() {
            return this.command;
        }

        @Generated
        public Boolean getConnect() {
            return this.connect;
        }

        @Generated
        public ESErrorMessage getError() {
            return this.error;
        }

        @Generated
        public void setChanges(Map<String, Object> changes) {
            this.changes = changes;
        }

        @Generated
        public void setTimestamp(LocalDateTime timestamp) {
            this.timestamp = timestamp;
        }

        @Generated
        public void setDuration(long duration) {
            this.duration = duration;
        }

        @Generated
        public void setSource(ID source) {
            this.source = source;
        }

        @Generated
        public void setClient(ID client) {
            this.client = client;
        }

        @Generated
        public void setWorld(World world) {
            this.world = world;
        }

        @Generated
        public void setOwnership(Ownership ownership) {
            this.ownership = ownership;
        }

        @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.WRAPPER_OBJECT)
        @Generated
        public void setCommand(Command command) {
            this.command = command;
        }

        @Generated
        public void setConnect(Boolean connect) {
            this.connect = connect;
        }

        @Generated
        public void setError(ESErrorMessage error) {
            this.error = error;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ESLogEntry)) {
                return false;
            }
            ESLogEntry other = (ESLogEntry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getDuration() != other.getDuration()) {
                return false;
            }
            Boolean this$connect = this.getConnect();
            Boolean other$connect = other.getConnect();
            if (this$connect == null ? other$connect != null : !((Object)this$connect).equals(other$connect)) {
                return false;
            }
            Map<String, Object> this$changes = this.getChanges();
            Map<String, Object> other$changes = other.getChanges();
            if (this$changes == null ? other$changes != null : !((Object)this$changes).equals(other$changes)) {
                return false;
            }
            LocalDateTime this$timestamp = this.getTimestamp();
            LocalDateTime other$timestamp = other.getTimestamp();
            if (this$timestamp == null ? other$timestamp != null : !((Object)this$timestamp).equals(other$timestamp)) {
                return false;
            }
            ID this$source = this.getSource();
            ID other$source = other.getSource();
            if (this$source == null ? other$source != null : !((Object)this$source).equals(other$source)) {
                return false;
            }
            ID this$client = this.getClient();
            ID other$client = other.getClient();
            if (this$client == null ? other$client != null : !((Object)this$client).equals(other$client)) {
                return false;
            }
            World this$world = this.getWorld();
            World other$world = other.getWorld();
            if (this$world == null ? other$world != null : !((Object)this$world).equals(other$world)) {
                return false;
            }
            Ownership this$ownership = this.getOwnership();
            Ownership other$ownership = other.getOwnership();
            if (this$ownership == null ? other$ownership != null : !((Object)this$ownership).equals(other$ownership)) {
                return false;
            }
            Command this$command = this.getCommand();
            Command other$command = other.getCommand();
            if (this$command == null ? other$command != null : !this$command.equals(other$command)) {
                return false;
            }
            ESErrorMessage this$error = this.getError();
            ESErrorMessage other$error = other.getError();
            return !(this$error == null ? other$error != null : !((Object)this$error).equals(other$error));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ESLogEntry;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $duration = this.getDuration();
            result = result * 59 + (int)($duration ^ $duration >>> 32);
            Boolean $connect = this.getConnect();
            result = result * 59 + ($connect == null ? 43 : ((Object)$connect).hashCode());
            Map<String, Object> $changes = this.getChanges();
            result = result * 59 + ($changes == null ? 43 : ((Object)$changes).hashCode());
            LocalDateTime $timestamp = this.getTimestamp();
            result = result * 59 + ($timestamp == null ? 43 : ((Object)$timestamp).hashCode());
            ID $source = this.getSource();
            result = result * 59 + ($source == null ? 43 : ((Object)$source).hashCode());
            ID $client = this.getClient();
            result = result * 59 + ($client == null ? 43 : ((Object)$client).hashCode());
            World $world = this.getWorld();
            result = result * 59 + ($world == null ? 43 : ((Object)$world).hashCode());
            Ownership $ownership = this.getOwnership();
            result = result * 59 + ($ownership == null ? 43 : ((Object)$ownership).hashCode());
            Command $command = this.getCommand();
            result = result * 59 + ($command == null ? 43 : $command.hashCode());
            ESErrorMessage $error = this.getError();
            result = result * 59 + ($error == null ? 43 : ((Object)$error).hashCode());
            return result;
        }

        @Generated
        public ESLogEntry() {
        }

        @Generated
        public String toString() {
            return "ElasticSearchSessionListener.ESLogEntry(super=" + super.toString() + ", changes=" + String.valueOf(this.getChanges()) + ", timestamp=" + String.valueOf(this.getTimestamp()) + ", duration=" + this.getDuration() + ", source=" + String.valueOf(this.getSource()) + ", client=" + String.valueOf(this.getClient()) + ", world=" + String.valueOf(this.getWorld()) + ", ownership=" + String.valueOf(this.getOwnership()) + ", command=" + String.valueOf(this.getCommand()) + ", connect=" + String.valueOf(this.getConnect()) + ", error=" + String.valueOf(this.getError()) + ")";
        }
    }
}

