/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.openvidu.java.client.Connection;
import io.openvidu.java.client.ConnectionProperties;
import io.openvidu.java.client.ConnectionType;
import io.openvidu.java.client.OpenVidu;
import io.openvidu.java.client.OpenViduException;
import io.openvidu.java.client.OpenViduHttpException;
import io.openvidu.java.client.OpenViduRole;
import io.openvidu.java.client.Session;
import io.openvidu.java.client.SessionProperties;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.vrspace.server.obj.Client;
import org.vrspace.server.obj.World;

@Component
public class StreamManager {
    private static final Logger log = LoggerFactory.getLogger(StreamManager.class);
    public static final String mainConnectionId = "OpenViduMain";
    public static final String additionalConnectionId = "OpenViduScreen";
    @Value(value="#{systemProperties['openvidu.publicurl'] ?: '${openvidu.publicurl:none}' }")
    private String openViduUrl;
    @Value(value="#{systemProperties['openvidu.secret'] ?: '${openvidu.secret:none}' }")
    private String openViduSecret;
    @Autowired
    ObjectMapper objectMapper;
    private Map<String, Session> sessions = new ConcurrentHashMap<String, Session>();

    private Session startStreamingSession(String name) throws OpenViduException {
        Session ret = null;
        OpenVidu openVidu = new OpenVidu(this.openViduUrl, this.openViduSecret);
        SessionProperties properties = new SessionProperties.Builder().customSessionId(name).build();
        try {
            ret = openVidu.createSession(properties);
            this.sessions.put(name, ret);
            log.info("Created streaming session " + name);
        }
        catch (OpenViduHttpException e) {
            if (e.getStatus() == 409) {
                ret = this.sessions.get(name);
                if (ret == null) {
                    throw e;
                }
            }
            throw e;
        }
        return ret;
    }

    private String createConnection(Session session, String sessionData) throws OpenViduException {
        ConnectionProperties connectionProperties = new ConnectionProperties.Builder().type(ConnectionType.WEBRTC).role(OpenViduRole.PUBLISHER).data(sessionData).build();
        String token = null;
        try {
            token = session.createConnection(connectionProperties).getToken();
        }
        catch (OpenViduHttpException e) {
            if (e.getStatus() == 404) {
                log.error("Error generating token - session not found. Creating new session", (Throwable)e);
                session = this.startStreamingSession(session.getSessionId());
                token = session.createConnection(connectionProperties).getToken();
            }
            throw e;
        }
        return token;
    }

    public void disconnect(Client client, String sessionName) throws OpenViduException {
        if (client.getToken(mainConnectionId) != null && sessionName != null) {
            client.clearToken(mainConnectionId);
            client.clearToken(additionalConnectionId);
            Session session = this.sessions.get(sessionName);
            if (session != null) {
                session.fetch();
                List activeConnections = session.getActiveConnections();
                log.debug("Disconnecting client " + String.valueOf(client.getId()) + " from " + sessionName + ", current active connections " + activeConnections.size());
                for (Connection connection : activeConnections) {
                    if (!client.getId().toString().equals(connection.getServerData())) continue;
                    session.forceDisconnect(connection);
                    log.debug("Disconnected client " + String.valueOf(client.getId()) + " from world " + sessionName);
                    if (activeConnections.size() > 1) continue;
                    this.sessions.remove(sessionName);
                    log.info("Removed streaming session " + sessionName);
                }
            }
        }
    }

    public void join(Client client) {
        if (this.isAvailable()) {
            try {
                this.disconnect(client, client.getWorld().getName());
            }
            catch (OpenViduException e) {
                log.error("Failed to disconnect client " + String.valueOf(client), (Throwable)e);
            }
            String sessionName = this.getSessionName(client.getWorld());
            try {
                Session session = this.startStreamingSession(sessionName);
                try {
                    String token = this.createConnection(session, this.sessionData(client, "main"));
                    client.setToken(mainConnectionId, token);
                    log.debug("Client " + String.valueOf(client.getId()) + " joined session " + client.getWorld().getName() + " with token " + token);
                }
                catch (OpenViduException e) {
                    log.error("Can't generate OpenVidu token", (Throwable)e);
                }
                catch (JsonProcessingException e) {
                    log.error("JSON error", (Throwable)e);
                }
            }
            catch (OpenViduException e) {
                log.error("Can't start streaming session " + sessionName, (Throwable)e);
            }
        }
    }

    private String getSessionName(World world) {
        String sessionName = world.getToken();
        if (sessionName == null) {
            sessionName = world.getName();
        }
        return sessionName;
    }

    public String addConnection(Client client) {
        if (this.isAvailable()) {
            String sessionName = this.getSessionName(client.getWorld());
            try {
                Session session = this.startStreamingSession(sessionName);
                String token = this.createConnection(session, this.sessionData(client, "screen"));
                client.setToken(additionalConnectionId, token);
                log.debug("Client " + String.valueOf(client.getId()) + " added connection to session " + client.getWorld().getName() + " with token " + token);
                return token;
            }
            catch (OpenViduException e) {
                log.error("Can't generate OpenVidu token", (Throwable)e);
            }
            catch (JsonProcessingException e) {
                log.error("JSON error", (Throwable)e);
            }
        }
        return null;
    }

    public void closeConection(Client client) {
        if (this.isAvailable() && client.getToken(additionalConnectionId) != null) {
            client.clearToken(additionalConnectionId);
            Session session = this.sessions.get(this.getSessionName(client.getWorld()));
            if (session != null) {
                try {
                    session.fetch();
                    List activeConnections = session.getActiveConnections();
                    log.debug("Disconnecting client " + String.valueOf(client.getId()) + ", current active connections " + activeConnections.size());
                    for (Connection connection : activeConnections) {
                        SessionData data = this.sessionData(connection.getServerData());
                        if (!client.getId().equals(data.getClientId())) continue;
                        session.forceDisconnect(connection);
                    }
                }
                catch (Exception e) {
                    log.error("Can't close OpenVidu connection for " + String.valueOf(client.getId()), (Throwable)e);
                }
            }
        }
    }

    public boolean isAvailable() {
        return !"none".equals(this.openViduUrl) && !"none".equals(this.openViduSecret);
    }

    SessionData sessionData(String data) throws JsonMappingException, JsonProcessingException {
        return (SessionData)this.objectMapper.readValue(data, SessionData.class);
    }

    String sessionData(Client client, String type) throws JsonProcessingException {
        SessionData sessionData = new SessionData();
        sessionData.clientId = client.getId();
        sessionData.name = this.getSessionName(client.getWorld());
        sessionData.type = type;
        return this.objectMapper.writeValueAsString((Object)sessionData);
    }

    public class SessionData {
        private Long clientId;
        private String name;
        private String type;

        @Generated
        public Long getClientId() {
            return this.clientId;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getType() {
            return this.type;
        }

        @Generated
        public void setClientId(Long clientId) {
            this.clientId = clientId;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setType(String type) {
            this.type = type;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SessionData)) {
                return false;
            }
            SessionData other = (SessionData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$clientId = this.getClientId();
            Long other$clientId = other.getClientId();
            if (this$clientId == null ? other$clientId != null : !((Object)this$clientId).equals(other$clientId)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SessionData;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $clientId = this.getClientId();
            result = result * 59 + ($clientId == null ? 43 : ((Object)$clientId).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "StreamManager.SessionData(clientId=" + String.valueOf(this.getClientId()) + ", name=" + this.getName() + ", type=" + this.getType() + ")";
        }

        @Generated
        public SessionData() {
        }
    }
}

