/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.vrspace.server.core.WorldManager;
import org.vrspace.server.dto.ClientResponse;
import org.vrspace.server.dto.SceneChange;
import org.vrspace.server.obj.Client;
import org.vrspace.server.obj.VRObject;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.WRAPPER_OBJECT)
public class Add
implements SceneChange {
    List<VRObject> objects = new LinkedList<VRObject>();

    public Add(Collection<VRObject> objects) {
        this.objects.addAll(objects);
    }

    public Add(VRObject ... objects) {
        VRObject[] vRObjectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            VRObject t = vRObjectArray[n2];
            this.addObject(t);
            ++n2;
        }
    }

    public Add addObject(VRObject t) {
        this.objects.add(t);
        return this;
    }

    @Override
    public ClientResponse execute(WorldManager world, Client client) {
        List<VRObject> added = world.add(client, this.objects);
        client.getScene().publishAll(added);
        List ret = added.stream().map(o -> o.getObjectId().map()).collect(Collectors.toList());
        return new ClientResponse(ret);
    }

    @Generated
    public List<VRObject> getObjects() {
        return this.objects;
    }

    @Generated
    public void setObjects(List<VRObject> objects) {
        this.objects = objects;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Add)) {
            return false;
        }
        Add other = (Add)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<VRObject> this$objects = this.getObjects();
        List<VRObject> other$objects = other.getObjects();
        return !(this$objects == null ? other$objects != null : !((Object)this$objects).equals(other$objects));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Add;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<VRObject> $objects = this.getObjects();
        result = result * 59 + ($objects == null ? 43 : ((Object)$objects).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Add(objects=" + String.valueOf(this.getObjects()) + ")";
    }

    @Generated
    public Add() {
    }
}

