/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Optional;
import lombok.Generated;
import org.vrspace.server.core.WorldManager;
import org.vrspace.server.dto.ClientResponse;
import org.vrspace.server.dto.Command;
import org.vrspace.server.obj.Client;
import org.vrspace.server.obj.UserData;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.WRAPPER_OBJECT)
public class Data
implements Command {
    private String action;
    private String key;
    private String value;

    @Override
    public ClientResponse execute(WorldManager worldManager, Client client) throws Exception {
        if ("list".equals(this.action)) {
            return new ClientResponse(worldManager.getDb().listUserData(client.getId()));
        }
        if ("clear".equals(this.action) && this.key != null) {
            worldManager.getDb().findUserData(client.getId(), this.key).ifPresent(data -> worldManager.getDb().delete(data));
        } else if ("get".equals(this.action) && this.key != null) {
            Optional<UserData> data2 = worldManager.getDb().findUserData(client.getId(), this.key);
            if (data2.isPresent()) {
                return new ClientResponse(data2.get());
            }
        } else if ("set".equals(this.action) && this.key != null && this.value != null) {
            Optional<UserData> data3 = worldManager.getDb().findUserData(client.getId(), this.key);
            UserData updated = null;
            if (data3.isPresent()) {
                updated = data3.get();
                updated.setValue(this.value);
            } else {
                updated = new UserData(client, this.key, this.value);
            }
            worldManager.getDb().save(updated);
        } else {
            throw new UnsupportedOperationException("Invalid action:" + this.action);
        }
        return null;
    }

    @Generated
    public String getAction() {
        return this.action;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public String getValue() {
        return this.value;
    }

    @Generated
    public void setAction(String action) {
        this.action = action;
    }

    @Generated
    public void setKey(String key) {
        this.key = key;
    }

    @Generated
    public void setValue(String value) {
        this.value = value;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Data)) {
            return false;
        }
        Data other = (Data)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$action = this.getAction();
        String other$action = other.getAction();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Data;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Data(action=" + this.getAction() + ", key=" + this.getKey() + ", value=" + this.getValue() + ")";
    }

    @Generated
    public Data() {
    }
}

