/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.dto;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.invoke.CallSite;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.vrspace.server.core.WorldManager;
import org.vrspace.server.dto.ClientResponse;
import org.vrspace.server.dto.Command;
import org.vrspace.server.obj.Client;
import org.vrspace.server.obj.Entity;

public class Describe
implements Command {
    private String className;

    @Override
    public ClientResponse execute(WorldManager world, Client client) throws ClassNotFoundException {
        if (this.className == null) {
            Map<String, String> ret = world.listClasses().stream().collect(Collectors.toMap(Class::getSimpleName, c -> c.getSuperclass().getSimpleName()));
            return new ClientResponse(ret);
        }
        LinkedHashMap<CallSite, String> ret = new LinkedHashMap<CallSite, String>();
        Class<?> cls = Class.forName("org.vrspace.server." + this.className);
        Map<String, Field> fields = this.getFields(cls);
        Method[] methodArray = cls.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method m = methodArray[n2];
            if (m.getName().startsWith("get") && !"getClass".equals(m.getName()) && !m.isAnnotationPresent(JsonIgnore.class)) {
                String fieldName = m.getName().substring(3, 4).toLowerCase() + m.getName().substring(4);
                String fieldType = m.getReturnType().getSimpleName();
                if (fields.containsKey(fieldName)) {
                    ret.put((CallSite)((Object)fieldName), fieldType);
                }
            }
            ++n2;
        }
        return new ClientResponse(ret);
    }

    private Map<String, Field> getFields(Class<?> cls) {
        Map<Object, Object> ret = null;
        ret = Entity.class.isAssignableFrom(cls.getSuperclass()) ? this.getFields(cls.getSuperclass()) : new LinkedHashMap();
        Field[] fieldArray = cls.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (!f.isAnnotationPresent(JsonIgnore.class) && !Modifier.isStatic(f.getModifiers())) {
                ret.put(f.getName(), f);
            }
            ++n2;
        }
        return ret;
    }

    @Generated
    public String getClassName() {
        return this.className;
    }

    @Generated
    public void setClassName(String className) {
        this.className = className;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Describe)) {
            return false;
        }
        Describe other = (Describe)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        return !(this$className == null ? other$className != null : !this$className.equals(other$className));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Describe;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Describe(className=" + this.getClassName() + ")";
    }

    @Generated
    public Describe() {
    }
}

