/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.dto;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vrspace.server.core.WorldManager;
import org.vrspace.server.dto.ClientResponse;
import org.vrspace.server.dto.Command;
import org.vrspace.server.obj.Client;

public class Game
implements Command {
    private static final Logger log = LoggerFactory.getLogger(Game.class);
    private Long id;
    private String action = "join";

    @Override
    public ClientResponse execute(WorldManager worldManager, Client client) throws Exception {
        org.vrspace.server.obj.Game game = worldManager.get(org.vrspace.server.obj.Game.class, this.id);
        if (game == null) {
            log.error("Client " + String.valueOf(client) + " wants to join non-existing game " + String.valueOf(this.id));
        } else if ("join".equals(this.action)) {
            game.join(client);
        } else if ("quit".equals(this.action)) {
            game.quit(client);
            if (worldManager.isOwner(client, game)) {
                log.info("Owner " + String.valueOf(client) + " has quit " + String.valueOf(game));
                client.getScene().unpublish(game);
                worldManager.remove(client, game);
            }
        } else if ("start".equals(this.action)) {
            game.start(client);
        } else if ("end".equals(this.action)) {
            game.end(client);
        }
        return null;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getAction() {
        return this.action;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setAction(String action) {
        this.action = action;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Game)) {
            return false;
        }
        Game other = (Game)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$action = this.getAction();
        String other$action = other.getAction();
        return !(this$action == null ? other$action != null : !this$action.equals(other$action));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Game;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Game(id=" + String.valueOf(this.getId()) + ", action=" + this.getAction() + ")";
    }

    @Generated
    public Game() {
    }
}

