/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import lombok.Generated;
import org.vrspace.server.core.GroupManager;
import org.vrspace.server.core.WorldManager;
import org.vrspace.server.dto.ClientResponse;
import org.vrspace.server.dto.Command;
import org.vrspace.server.obj.Client;
import org.vrspace.server.obj.UserGroup;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.WRAPPER_OBJECT)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class Group
implements Command {
    private String action;
    private String name;
    private long clientId;
    private String text;

    @Override
    public ClientResponse execute(WorldManager worldManager, Client client) throws Exception {
        GroupManager gm = GroupManager.getInstance();
        if ("list".equals(this.action)) {
            return new ClientResponse(gm.listGroups(client));
        }
        if ("create".equals(this.action)) {
            gm.createGroup(client, new UserGroup(this.name));
        } else if ("delete".equals(this.action)) {
            UserGroup group = gm.getGroup(client, this.name);
            gm.deleteGroup(client, group);
        } else {
            if ("show".equals(this.action)) {
                UserGroup group = gm.getGroup(client, this.name);
                return new ClientResponse(gm.show(group));
            }
            if ("join".equals(this.action)) {
                UserGroup group = gm.getGroup(client, this.name);
                gm.join(group, client);
            } else if ("invite".equals(this.action)) {
                UserGroup group = gm.getGroup(client, this.name);
                gm.invite(group, this.clientId, client);
            } else if ("ask".equals(this.action)) {
                UserGroup group = gm.getGroup(client, this.name);
                gm.ask(group, client);
            } else if ("accept".equals(this.action)) {
                UserGroup group = gm.getGroup(client, this.name);
                gm.accept(group, client);
            } else if ("allow".equals(this.action)) {
                UserGroup group = gm.getGroup(client, this.name);
                gm.allow(group, this.clientId, client);
            } else if ("leave".equals(this.action)) {
                UserGroup group = gm.getGroup(client, this.name);
                gm.leave(group, client);
            } else if ("kick".equals(this.action)) {
                UserGroup group = gm.getGroup(client, this.name);
                gm.kick(group, this.clientId, client);
            } else if ("write".equals(this.action)) {
                UserGroup group = gm.getGroup(client, this.name);
                gm.write(client, group, this.text);
            } else {
                throw new UnsupportedOperationException("Invalid action:" + this.action);
            }
        }
        return null;
    }

    @Generated
    public String getAction() {
        return this.action;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public long getClientId() {
        return this.clientId;
    }

    @Generated
    public String getText() {
        return this.text;
    }

    @Generated
    public void setAction(String action) {
        this.action = action;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setClientId(long clientId) {
        this.clientId = clientId;
    }

    @Generated
    public void setText(String text) {
        this.text = text;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Group)) {
            return false;
        }
        Group other = (Group)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getClientId() != other.getClientId()) {
            return false;
        }
        String this$action = this.getAction();
        String other$action = other.getAction();
        if (this$action == null ? other$action != null : !this$action.equals(other$action)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        return !(this$text == null ? other$text != null : !this$text.equals(other$text));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Group;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $clientId = this.getClientId();
        result = result * 59 + (int)($clientId ^ $clientId >>> 32);
        String $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : $action.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Group(action=" + this.getAction() + ", name=" + this.getName() + ", clientId=" + this.getClientId() + ", text=" + this.getText() + ")";
    }

    @Generated
    public Group() {
    }

    @Generated
    public Group(String action, String name, long clientId, String text) {
        this.action = action;
        this.name = name;
        this.clientId = clientId;
        this.text = text;
    }
}

