/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.obj;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.Transient;
import org.vrspace.server.dto.Add;
import org.vrspace.server.dto.Remove;
import org.vrspace.server.dto.VREvent;
import org.vrspace.server.obj.Client;
import org.vrspace.server.obj.User;
import org.vrspace.server.obj.VRObject;
import reactor.core.publisher.Mono;

public abstract class Bot
extends User {
    private static final Logger log = LoggerFactory.getLogger(Bot.class);
    private String gender;
    private String lang;
    @JsonIgnore
    private String url;
    @JsonIgnore
    @Transient
    private Map<String, String> parameterMap = new HashMap<String, String>();

    public String getParameter(String key) {
        return this.parameterMap.get(key);
    }

    public abstract void selfTest() throws Exception;

    public abstract Mono<String> getResponseAsync(Client var1, String var2);

    public void respondTo(Client c, String what) {
        this.getResponseAsync(c, what).subscribe(response -> this.write((String)response));
    }

    public void write(String what) {
        VREvent event = new VREvent(this);
        HashMap<String, Object> changes = new HashMap<String, Object>();
        changes.put("wrote", what);
        event.setChanges(changes);
        this.notifyListeners(event);
    }

    @Override
    public void processEvent(VREvent event) {
        log.debug(String.valueOf(this) + " received event: " + String.valueOf(event));
        if (!event.getSource().isActive()) {
            event.getSource().removeListener(this);
        } else if (event.getChanges().containsKey("wrote")) {
            String what = (String)event.getChanges().get("wrote");
            this.respondTo(event.getClient(), what);
        }
    }

    public void objectsAdded(List<VRObject> objects) {
        log.debug("New objects in the scene " + String.valueOf(objects));
    }

    public void objectsRemoved(List<Map<String, Long>> objects) {
        log.debug("Removed objects from the scene " + String.valueOf(objects));
    }

    @Override
    public void sendMessage(Object o) {
        log.debug(String.valueOf(this) + " received message:" + String.valueOf(o));
        if (o instanceof Add) {
            this.objectsAdded(((Add)o).getObjects());
        } else if (o instanceof Remove) {
            this.objectsRemoved(((Remove)o).getObjects());
        }
    }

    @Override
    public String toString() {
        return this.getId().toString();
    }

    @Generated
    public String getGender() {
        return this.gender;
    }

    @Generated
    public String getLang() {
        return this.lang;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public Map<String, String> getParameterMap() {
        return this.parameterMap;
    }

    @Generated
    public void setGender(String gender) {
        this.gender = gender;
    }

    @Generated
    public void setLang(String lang) {
        this.lang = lang;
    }

    @JsonIgnore
    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @JsonIgnore
    @Generated
    public void setParameterMap(Map<String, String> parameterMap) {
        this.parameterMap = parameterMap;
    }

    @Generated
    public Bot() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Bot)) {
            return false;
        }
        Bot other = (Bot)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Bot;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

