/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.obj;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.core.JsonProcessingException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.Transient;
import org.springframework.data.neo4j.core.schema.Node;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.client.WebClient;
import org.vrspace.server.obj.Bot;
import org.vrspace.server.obj.Client;
import reactor.core.publisher.Mono;

@Node
public class BotLibre
extends Bot {
    private static final Logger log = LoggerFactory.getLogger(BotLibre.class);
    @JsonIgnore
    @Transient
    private WebClient webClient = WebClient.create();

    @Override
    public void selfTest() throws Exception {
        log.debug((String)this.getResponseAsync(new Client(), "hello again").onErrorResume(e -> Mono.error((Throwable)e)).block());
    }

    @Override
    public Mono<String> getResponseAsync(Client client, String message) {
        Query q = new Query();
        q.setApplication(this.getParameter("application"));
        q.setInstance(this.getParameter("instance"));
        q.setConversation(client.getToken(this.serviceId()));
        q.setMessage(message);
        log.debug(String.valueOf(this) + " request: " + String.valueOf(q));
        try {
            return ((WebClient.RequestBodySpec)this.webClient.post().uri(this.getUrl(), new Object[0])).contentType(MediaType.APPLICATION_JSON).bodyValue((Object)this.getMapper().writeValueAsString((Object)q)).exchangeToMono(clientResponse -> {
                if (clientResponse.statusCode().equals(HttpStatus.OK)) {
                    return clientResponse.bodyToMono(Response.class).map(response -> {
                        String ret = response.getMessage();
                        String conversationId = response.getConversation();
                        client.setToken(this.serviceId(), conversationId);
                        return ret;
                    });
                }
                return clientResponse.createException().flatMap(Mono::error);
            });
        }
        catch (JsonProcessingException e) {
            log.error("Can't get response to: " + message, (Throwable)e);
            return Mono.error((Throwable)e);
        }
    }

    private String serviceId() {
        return this.getObjectId().toString();
    }

    @Generated
    public WebClient getWebClient() {
        return this.webClient;
    }

    @JsonIgnore
    @Generated
    public void setWebClient(WebClient webClient) {
        this.webClient = webClient;
    }

    @Generated
    public BotLibre() {
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BotLibre)) {
            return false;
        }
        BotLibre other = (BotLibre)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BotLibre;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "BotLibre(super=" + super.toString() + ")";
    }

    public static class Query {
        private String application;
        private String instance;
        private String conversation;
        private String message;
        private String emote;
        private boolean correction;
        private boolean offensive;
        private boolean disconnect;
        private boolean includeQuestion;

        @Generated
        public String getApplication() {
            return this.application;
        }

        @Generated
        public String getInstance() {
            return this.instance;
        }

        @Generated
        public String getConversation() {
            return this.conversation;
        }

        @Generated
        public String getMessage() {
            return this.message;
        }

        @Generated
        public String getEmote() {
            return this.emote;
        }

        @Generated
        public boolean isCorrection() {
            return this.correction;
        }

        @Generated
        public boolean isOffensive() {
            return this.offensive;
        }

        @Generated
        public boolean isDisconnect() {
            return this.disconnect;
        }

        @Generated
        public boolean isIncludeQuestion() {
            return this.includeQuestion;
        }

        @Generated
        public void setApplication(String application) {
            this.application = application;
        }

        @Generated
        public void setInstance(String instance) {
            this.instance = instance;
        }

        @Generated
        public void setConversation(String conversation) {
            this.conversation = conversation;
        }

        @Generated
        public void setMessage(String message) {
            this.message = message;
        }

        @Generated
        public void setEmote(String emote) {
            this.emote = emote;
        }

        @Generated
        public void setCorrection(boolean correction) {
            this.correction = correction;
        }

        @Generated
        public void setOffensive(boolean offensive) {
            this.offensive = offensive;
        }

        @Generated
        public void setDisconnect(boolean disconnect) {
            this.disconnect = disconnect;
        }

        @Generated
        public void setIncludeQuestion(boolean includeQuestion) {
            this.includeQuestion = includeQuestion;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Query)) {
                return false;
            }
            Query other = (Query)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isCorrection() != other.isCorrection()) {
                return false;
            }
            if (this.isOffensive() != other.isOffensive()) {
                return false;
            }
            if (this.isDisconnect() != other.isDisconnect()) {
                return false;
            }
            if (this.isIncludeQuestion() != other.isIncludeQuestion()) {
                return false;
            }
            String this$application = this.getApplication();
            String other$application = other.getApplication();
            if (this$application == null ? other$application != null : !this$application.equals(other$application)) {
                return false;
            }
            String this$instance = this.getInstance();
            String other$instance = other.getInstance();
            if (this$instance == null ? other$instance != null : !this$instance.equals(other$instance)) {
                return false;
            }
            String this$conversation = this.getConversation();
            String other$conversation = other.getConversation();
            if (this$conversation == null ? other$conversation != null : !this$conversation.equals(other$conversation)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            String this$emote = this.getEmote();
            String other$emote = other.getEmote();
            return !(this$emote == null ? other$emote != null : !this$emote.equals(other$emote));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Query;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isCorrection() ? 79 : 97);
            result = result * 59 + (this.isOffensive() ? 79 : 97);
            result = result * 59 + (this.isDisconnect() ? 79 : 97);
            result = result * 59 + (this.isIncludeQuestion() ? 79 : 97);
            String $application = this.getApplication();
            result = result * 59 + ($application == null ? 43 : $application.hashCode());
            String $instance = this.getInstance();
            result = result * 59 + ($instance == null ? 43 : $instance.hashCode());
            String $conversation = this.getConversation();
            result = result * 59 + ($conversation == null ? 43 : $conversation.hashCode());
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            String $emote = this.getEmote();
            result = result * 59 + ($emote == null ? 43 : $emote.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BotLibre.Query(application=" + this.getApplication() + ", instance=" + this.getInstance() + ", conversation=" + this.getConversation() + ", message=" + this.getMessage() + ", emote=" + this.getEmote() + ", correction=" + this.isCorrection() + ", offensive=" + this.isOffensive() + ", disconnect=" + this.isDisconnect() + ", includeQuestion=" + this.isIncludeQuestion() + ")";
        }

        @Generated
        public Query() {
        }
    }

    public static class Response {
        private String message;
        private String conversation;
        private String emote;
        private String avatar;
        private String avatarType;
        private String avatarTalk;
        private String avatarTalkType;
        private String avatarBackground;

        @Generated
        public String getMessage() {
            return this.message;
        }

        @Generated
        public String getConversation() {
            return this.conversation;
        }

        @Generated
        public String getEmote() {
            return this.emote;
        }

        @Generated
        public String getAvatar() {
            return this.avatar;
        }

        @Generated
        public String getAvatarType() {
            return this.avatarType;
        }

        @Generated
        public String getAvatarTalk() {
            return this.avatarTalk;
        }

        @Generated
        public String getAvatarTalkType() {
            return this.avatarTalkType;
        }

        @Generated
        public String getAvatarBackground() {
            return this.avatarBackground;
        }

        @Generated
        public void setMessage(String message) {
            this.message = message;
        }

        @Generated
        public void setConversation(String conversation) {
            this.conversation = conversation;
        }

        @Generated
        public void setEmote(String emote) {
            this.emote = emote;
        }

        @Generated
        public void setAvatar(String avatar) {
            this.avatar = avatar;
        }

        @Generated
        public void setAvatarType(String avatarType) {
            this.avatarType = avatarType;
        }

        @Generated
        public void setAvatarTalk(String avatarTalk) {
            this.avatarTalk = avatarTalk;
        }

        @Generated
        public void setAvatarTalkType(String avatarTalkType) {
            this.avatarTalkType = avatarTalkType;
        }

        @Generated
        public void setAvatarBackground(String avatarBackground) {
            this.avatarBackground = avatarBackground;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Response)) {
                return false;
            }
            Response other = (Response)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$message = this.getMessage();
            String other$message = other.getMessage();
            if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
                return false;
            }
            String this$conversation = this.getConversation();
            String other$conversation = other.getConversation();
            if (this$conversation == null ? other$conversation != null : !this$conversation.equals(other$conversation)) {
                return false;
            }
            String this$emote = this.getEmote();
            String other$emote = other.getEmote();
            if (this$emote == null ? other$emote != null : !this$emote.equals(other$emote)) {
                return false;
            }
            String this$avatar = this.getAvatar();
            String other$avatar = other.getAvatar();
            if (this$avatar == null ? other$avatar != null : !this$avatar.equals(other$avatar)) {
                return false;
            }
            String this$avatarType = this.getAvatarType();
            String other$avatarType = other.getAvatarType();
            if (this$avatarType == null ? other$avatarType != null : !this$avatarType.equals(other$avatarType)) {
                return false;
            }
            String this$avatarTalk = this.getAvatarTalk();
            String other$avatarTalk = other.getAvatarTalk();
            if (this$avatarTalk == null ? other$avatarTalk != null : !this$avatarTalk.equals(other$avatarTalk)) {
                return false;
            }
            String this$avatarTalkType = this.getAvatarTalkType();
            String other$avatarTalkType = other.getAvatarTalkType();
            if (this$avatarTalkType == null ? other$avatarTalkType != null : !this$avatarTalkType.equals(other$avatarTalkType)) {
                return false;
            }
            String this$avatarBackground = this.getAvatarBackground();
            String other$avatarBackground = other.getAvatarBackground();
            return !(this$avatarBackground == null ? other$avatarBackground != null : !this$avatarBackground.equals(other$avatarBackground));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Response;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $message = this.getMessage();
            result = result * 59 + ($message == null ? 43 : $message.hashCode());
            String $conversation = this.getConversation();
            result = result * 59 + ($conversation == null ? 43 : $conversation.hashCode());
            String $emote = this.getEmote();
            result = result * 59 + ($emote == null ? 43 : $emote.hashCode());
            String $avatar = this.getAvatar();
            result = result * 59 + ($avatar == null ? 43 : $avatar.hashCode());
            String $avatarType = this.getAvatarType();
            result = result * 59 + ($avatarType == null ? 43 : $avatarType.hashCode());
            String $avatarTalk = this.getAvatarTalk();
            result = result * 59 + ($avatarTalk == null ? 43 : $avatarTalk.hashCode());
            String $avatarTalkType = this.getAvatarTalkType();
            result = result * 59 + ($avatarTalkType == null ? 43 : $avatarTalkType.hashCode());
            String $avatarBackground = this.getAvatarBackground();
            result = result * 59 + ($avatarBackground == null ? 43 : $avatarBackground.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BotLibre.Response(message=" + this.getMessage() + ", conversation=" + this.getConversation() + ", emote=" + this.getEmote() + ", avatar=" + this.getAvatar() + ", avatarType=" + this.getAvatarType() + ", avatarTalk=" + this.getAvatarTalk() + ", avatarTalkType=" + this.getAvatarTalkType() + ", avatarBackground=" + this.getAvatarBackground() + ")";
        }

        @Generated
        public Response() {
        }
    }
}

