/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.obj;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Base64;
import lombok.Generated;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECPoint;
import org.springframework.data.neo4j.core.schema.Node;
import org.springframework.data.neo4j.core.schema.Relationship;
import org.vrspace.server.obj.Client;
import org.vrspace.server.obj.Entity;

@Node
public class WebPushSubscription
extends Entity {
    @JsonIgnore
    @Relationship(type="SUBSCRIBED_CLIENT", direction=Relationship.Direction.OUTGOING)
    private Client client;
    private String endpoint;
    private String key;
    private String auth;

    @JsonIgnore
    public byte[] getAuthAsBytes() {
        return Base64.getDecoder().decode(this.getAuth());
    }

    @JsonIgnore
    public byte[] getKeyAsBytes() {
        return Base64.getDecoder().decode(this.getKey());
    }

    @JsonIgnore
    public PublicKey getUserPublicKey() throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchProviderException {
        KeyFactory kf = KeyFactory.getInstance("ECDH", "BC");
        ECNamedCurveParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec((String)"secp256r1");
        ECPoint point = ecSpec.getCurve().decodePoint(this.getKeyAsBytes());
        ECPublicKeySpec pubSpec = new ECPublicKeySpec(point, (ECParameterSpec)ecSpec);
        return kf.generatePublic((KeySpec)pubSpec);
    }

    @Generated
    public Client getClient() {
        return this.client;
    }

    @Generated
    public String getEndpoint() {
        return this.endpoint;
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    @Generated
    public String getAuth() {
        return this.auth;
    }

    @JsonIgnore
    @Generated
    public void setClient(Client client) {
        this.client = client;
    }

    @Generated
    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    @Generated
    public void setKey(String key) {
        this.key = key;
    }

    @Generated
    public void setAuth(String auth) {
        this.auth = auth;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebPushSubscription)) {
            return false;
        }
        WebPushSubscription other = (WebPushSubscription)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof WebPushSubscription;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Generated
    public WebPushSubscription() {
    }

    @Generated
    public WebPushSubscription(Client client, String endpoint, String key, String auth) {
        this.client = client;
        this.endpoint = endpoint;
        this.key = key;
        this.auth = auth;
    }

    @Override
    @Generated
    public String toString() {
        return "WebPushSubscription(client=" + String.valueOf(this.getClient()) + ", endpoint=" + this.getEndpoint() + ", key=" + this.getKey() + ", auth=" + this.getAuth() + ")";
    }
}

