/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.web;

import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.vrspace.server.dto.FileList;
import org.vrspace.server.obj.Content;

@RestController
@ConditionalOnProperty(value={"org.vrspace.adminUI.enabled"})
public class ContentManager {
    private static final Logger log = LoggerFactory.getLogger(ContentManager.class);
    @Value(value="${org.vrspace.adminUI.contentRoot}")
    private String root;
    @Value(value="${org.vrspace.adminUI.path}")
    private String uiPath;

    private String getPath(String path) {
        String fullPath = this.uiPath + "/pub/";
        path = ((String)path).length() < fullPath.length() ? null : ((String)path).substring(fullPath.length() - 1);
        path = StringUtils.isEmpty((CharSequence)path) ? this.root : this.root + (String)path;
        return path;
    }

    @PostMapping(value={"/pub/**"})
    public FileList list(@RequestParam(value="uploadFiles", required=false) MultipartFile[] uploadFiles, HttpServletRequest request) throws IOException {
        FileList ret = new FileList();
        String path = this.getPath(request.getRequestURI());
        ret.setPath(path);
        File dir = new File(path);
        log.debug("list " + path + " -> " + dir.getCanonicalPath());
        ArrayList<Content> dirs = new ArrayList<Content>();
        ArrayList<Content> files = new ArrayList<Content>();
        if (dir.isDirectory()) {
            File[] fileArray = dir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    dirs.add(new Content(file.getName(), null, "dir", file.length()));
                } else {
                    String mimeType = Files.probeContentType(file.toPath());
                    if (mimeType == null) {
                        mimeType = "application/octet-stream";
                    }
                    files.add(new Content(file.getName(), null, mimeType, file.length()));
                }
                ++n2;
            }
        }
        ret.getContentList().addAll(dirs);
        ret.getContentList().addAll(files);
        return ret;
    }

    @GetMapping(value={"/pub/**"})
    public ResponseEntity<byte[]> get(HttpServletRequest request) throws IOException {
        FileList ret = new FileList();
        String path = this.getPath(request.getRequestURI());
        ret.setPath(path);
        File file = new File(path);
        log.debug("get " + path + " -> " + file.getCanonicalPath());
        if (file.exists()) {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
            headers.setContentDispositionFormData(file.getName(), file.getName());
            byte[] contents = IOUtils.toByteArray((InputStream)new FileInputStream(file));
            ResponseEntity response = new ResponseEntity((Object)contents, (MultiValueMap)headers, (HttpStatusCode)HttpStatus.OK);
            return response;
        }
        return null;
    }

    @PutMapping(value={"/pub/**"})
    public void upload(HttpServletRequest request, String fileName, int fileSize, MultipartFile fileData) throws IOException {
        String path = this.getPath(request.getRequestURI());
        log.debug("uploading to " + path + ": " + fileName + " " + fileSize + " " + fileData.getSize());
    }
}

