/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.api;

import jakarta.servlet.http.HttpSession;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.vrspace.server.api.ClientControllerBase;
import org.vrspace.server.core.VRObjectRepository;
import org.vrspace.server.obj.Client;
import org.vrspace.server.obj.UserData;

@RestController
@RequestMapping(value={"/vrspace/api/user-data"})
public class Data
extends ClientControllerBase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Data.class);
    public static final String PATH = "/vrspace/api/user-data";
    @Autowired
    VRObjectRepository db;

    @GetMapping
    public List<UserData> listUserData(HttpSession session) {
        Client client = this.getAuthorisedClient(session);
        log.debug("Get user data, user: " + client);
        return this.db.listUserData(client.getId());
    }

    @PostMapping
    public ResponseEntity<Void> setUserData(@RequestBody UserData data, HttpSession session) {
        Client client = this.getAuthorisedClient(session);
        log.debug("Post user data, user: " + client);
        UserData existing = (UserData)this.db.get(this.db.findUserData(client.getId(), data.getKey()));
        if (existing == null) {
            existing = new UserData();
        }
        existing.setKey(data.getKey());
        existing.setValue(data.getValue());
        this.db.save(existing);
        if (existing.getId() == null) {
            return new ResponseEntity(HttpStatusCode.valueOf((int)201));
        }
        return new ResponseEntity(HttpStatusCode.valueOf((int)200));
    }

    @DeleteMapping
    public void clearUserData(HttpSession session) {
        Client client = this.getAuthorisedClient(session);
        log.debug("Clear user data, user: " + client);
        this.db.listUserData(client.getId()).forEach(data -> this.db.delete(data));
    }

    @DeleteMapping(value={"/{key}"})
    public void deleteUserData(@PathVariable String key, HttpSession session) {
        Client client = this.getAuthorisedClient(session);
        log.debug("Delete user data, user: " + client + " key: " + key);
        UserData existing = (UserData)this.db.get(this.db.findUserData(client.getId(), key));
        if (existing == null) {
            this.db.delete(existing);
        }
    }

    @GetMapping(value={"/{key}"})
    public ResponseEntity<UserData> getUserData(@PathVariable String key, HttpSession session) {
        Client client = this.getAuthorisedClient(session);
        log.debug("Delete user data, user: " + client + " key: " + key);
        UserData existing = (UserData)this.db.get(this.db.findUserData(client.getId(), key));
        if (existing == null) {
            return new ResponseEntity((Object)existing, HttpStatusCode.valueOf((int)200));
        }
        return new ResponseEntity(HttpStatusCode.valueOf((int)404));
    }
}

