/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.api;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.shiro.codec.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.ResolvableType;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthenticationToken;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.web.savedrequest.DefaultSavedRequest;
import org.springframework.util.ObjectUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.vrspace.server.api.ApiBase;
import org.vrspace.server.api.ApiException;
import org.vrspace.server.core.ClientFactory;
import org.vrspace.server.core.VRObjectRepository;
import org.vrspace.server.obj.User;

@RestController
@ConditionalOnProperty(value={"org.vrspace.oauth2.enabled"})
@RequestMapping(value={"/vrspace/api/oauth2"})
public class Oauth2Login
extends ApiBase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Oauth2Login.class);
    public static final String PATH = "/vrspace/api/oauth2";
    @Autowired
    private VRObjectRepository db;
    @Autowired
    private ClientFactory clientFactory;
    private ClientRegistrationRepository clientRegistrationRepository;

    public Oauth2Login(@Autowired ClientRegistrationRepository clientRegistrationRepository) {
        this.clientRegistrationRepository = clientRegistrationRepository;
    }

    @GetMapping(value={"/providers"})
    public Map<String, String> providers() {
        Iterable clientRegistrations = null;
        ResolvableType type = ResolvableType.forInstance((Object)this.clientRegistrationRepository).as(Iterable.class);
        if (type != ResolvableType.NONE && ClientRegistration.class.isAssignableFrom(type.resolveGenerics()[0])) {
            clientRegistrations = (Iterable)this.clientRegistrationRepository;
        }
        HashMap<String, String> oauth2AuthenticationUrls = new HashMap<String, String>();
        clientRegistrations.forEach(registration -> oauth2AuthenticationUrls.put(registration.getRegistrationId(), registration.getClientName()));
        return oauth2AuthenticationUrls;
    }

    @GetMapping(value={"/provider"})
    public ResponseEntity<String> setProvider(HttpSession session, HttpServletRequest request) {
        Object location = "/login";
        DefaultSavedRequest original = (DefaultSavedRequest)session.getAttribute("SPRING_SECURITY_SAVED_REQUEST");
        String[] providers = (String[])original.getParameterMap().get("provider");
        if (providers != null && providers.length > 0) {
            location = "/vrspace/api/oauth2/authorization/" + providers[0];
        }
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.FOUND).header("Location", new String[]{location})).body((Object)("Redirecting to " + (String)location));
    }

    /*
     * Enabled aggressive block sorting
     */
    @GetMapping(value={"/login"})
    public ResponseEntity<String> afterAuthentication(String name, String provider, String avatar, HttpSession session, HttpServletRequest request) {
        User client;
        String referrer;
        block4: {
            referrer = request.getHeader("Referer");
            log.info("Referer: " + referrer);
            if (ObjectUtils.isEmpty((Object)name)) {
                throw new ApiException("Argument required: name");
            }
            log.debug("oauth login as:" + name);
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            String identity = this.identity((OAuth2AuthenticationToken)authentication);
            client = (User)this.db.getClientByName(name, User.class);
            if (client != null) {
                if (client.getIdentity() != null && client.getIdentity().equals(identity)) {
                    log.debug("Welcome back: " + name);
                    break block4;
                } else {
                    log.error("Someone else uses name " + name + ": " + client.getIdentity());
                    session.invalidate();
                    return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.FOUND).header("Location", new String[]{referrer})).body((Object)("Redirecting to " + referrer));
                }
            }
            log.debug("Welcome new user: " + name);
            client = new User(name);
            client.setMesh(avatar);
            client.setIdentity(identity);
            client = (User)this.db.save(client);
        }
        session.setAttribute(this.clientFactory.clientNameAttribute(), (Object)name);
        session.setAttribute("local-user-id", (Object)client.getId());
        return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatusCode)HttpStatus.FOUND).header("Location", new String[]{referrer})).body((Object)("Redirecting to " + referrer));
    }

    private String identity(OAuth2AuthenticationToken token) {
        String realName;
        String authority = token.getAuthorizedClientRegistrationId();
        String hashedName = realName = (String)token.getPrincipal().getAttribute("name");
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA3-256");
            byte[] hashbytes = digest.digest(realName.getBytes(StandardCharsets.UTF_8));
            hashedName = Hex.encodeToString((byte[])hashbytes);
        }
        catch (Exception e) {
            log.error("Can't hash user name " + realName, (Throwable)e);
        }
        return authority + ":" + hashedName;
    }
}

