/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.api;

import jakarta.servlet.http.HttpSession;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.vrspace.server.api.ClientControllerBase;
import org.vrspace.server.core.VRObjectRepository;
import org.vrspace.server.obj.Client;
import org.vrspace.server.obj.WebPushSubscription;

@ConditionalOnProperty(value={"webpush.publicKey"})
@RestController
@RequestMapping(value={"/vrspace/api/webpush"})
public class WebPush
extends ClientControllerBase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebPush.class);
    public static final String PATH = "/vrspace/api/webpush";
    @Value(value="${webpush.publicKey}")
    private String publicKey;
    @Autowired
    private VRObjectRepository db;

    @PostMapping(value={"/subscribe"})
    public void subscribe(@RequestBody WebPushSubscription info, HttpSession session) {
        log.debug("WebPush register: " + info);
        Client client = this.getAuthorisedClient(session, this.db);
        Optional<WebPushSubscription> existing = this.db.listSubscriptions(client.getId()).stream().filter(sub -> sub.getEndpoint().equals(info.getEndpoint())).findAny();
        if (existing.isEmpty()) {
            info.setClient(client);
            this.db.save(info);
        } else {
            log.debug("Existing subscription: " + info);
        }
    }

    @PostMapping(value={"/unsubscribe"})
    public void unsubscribe(@RequestBody WebPushSubscription info, HttpSession session) {
        log.debug("WebPush unsubscribe: " + info);
        Client client = this.getAuthorisedClient(session, this.db);
        this.db.listSubscriptions(client.getId()).forEach(sub -> {
            if (sub.getEndpoint().equals(info.getEndpoint())) {
                this.db.delete(sub);
            }
        });
    }

    @GetMapping(value={"/publicKey"})
    public String getKey() {
        return this.publicKey;
    }
}

