/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.obj;

import com.fasterxml.jackson.annotation.JsonIgnore;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.annotation.Transient;
import org.springframework.data.neo4j.core.schema.Node;
import org.vrspace.server.core.WorldManager;
import org.vrspace.server.obj.Client;
import org.vrspace.server.obj.Entity;

@Node
public class World
extends Entity {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(World.class);
    @NonNull
    private String name;
    private boolean defaultWorld;
    private boolean publicWorld = true;
    private boolean temporaryWorld = false;
    @JsonIgnore
    @Transient
    private transient String token;
    @JsonIgnore
    private Client owner;

    public World(String name, boolean defaultWorld) {
        this.name = name;
        this.defaultWorld = defaultWorld;
    }

    public boolean enter(Client c, WorldManager wm) {
        if (!this.publicWorld && this.getOwner() != null && !c.equals(this.getOwner())) {
            String serviceId = this.tokenName();
            String token = c.getToken(serviceId);
            log.debug("Token for " + serviceId + ": " + this.getToken() + " Client offered: " + token);
            if (token == null) {
                return false;
            }
            return token.equals(this.getToken());
        }
        return true;
    }

    public void exit(Client c, WorldManager wm) {
        if (c.equals(this.getOwner())) {
            this.token = null;
        }
    }

    public String tokenName() {
        return this.getName();
    }

    @NonNull
    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public boolean isDefaultWorld() {
        return this.defaultWorld;
    }

    @Generated
    public boolean isPublicWorld() {
        return this.publicWorld;
    }

    @Generated
    public boolean isTemporaryWorld() {
        return this.temporaryWorld;
    }

    @Generated
    public String getToken() {
        return this.token;
    }

    @Generated
    public Client getOwner() {
        return this.owner;
    }

    @Generated
    public void setName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    @Generated
    public void setDefaultWorld(boolean defaultWorld) {
        this.defaultWorld = defaultWorld;
    }

    @Generated
    public void setPublicWorld(boolean publicWorld) {
        this.publicWorld = publicWorld;
    }

    @Generated
    public void setTemporaryWorld(boolean temporaryWorld) {
        this.temporaryWorld = temporaryWorld;
    }

    @JsonIgnore
    @Generated
    public void setToken(String token) {
        this.token = token;
    }

    @JsonIgnore
    @Generated
    public void setOwner(Client owner) {
        this.owner = owner;
    }

    @Generated
    public World() {
    }

    @Generated
    public World(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof World)) {
            return false;
        }
        World other = (World)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof World;
    }

    @Override
    @Generated
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "World(super=" + super.toString() + ", name=" + this.getName() + ", defaultWorld=" + this.isDefaultWorld() + ", publicWorld=" + this.isPublicWorld() + ", temporaryWorld=" + this.isTemporaryWorld() + ", token=" + this.getToken() + ", owner=" + this.getOwner() + ")";
    }
}

