/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.config;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.ser.std.StdScalarSerializer;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateDeserializer;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateSerializer;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.regex.Pattern;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.vrspace.server.core.ClassUtil;
import org.vrspace.server.obj.VRObject;
import org.vrspace.server.types.Private;

@Configuration
public class JacksonConfig {
    private Pattern htmlTag = Pattern.compile("<.+?>");

    @Bean(value={"objectMapper"})
    public ObjectMapper objectMapper() {
        ObjectMapper ret = this.objectMapperBuilder().build();
        ClassUtil.findSubclasses(VRObject.class).forEach(c -> ret.registerSubtypes(new Class[]{c}));
        ret.setAnnotationIntrospector((AnnotationIntrospector)new JacksonAnnotationIntrospector(){
            private static final long serialVersionUID = 1L;

            public boolean hasIgnoreMarker(AnnotatedMember m) {
                return super.hasIgnoreMarker(m) || m.hasAnnotation(Private.class);
            }
        });
        return ret;
    }

    @Bean(value={"privateMapper"})
    public ObjectMapper privateMapper() {
        ObjectMapper ret = this.objectMapperBuilder().build();
        ClassUtil.findSubclasses(VRObject.class).forEach(c -> ret.registerSubtypes(new Class[]{c}));
        return ret;
    }

    @Primary
    @Bean(value={"restMapper"})
    public ObjectMapper restMapper() {
        ObjectMapper ret = this.objectMapperBuilder().build();
        @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
        class NoTypes {
            NoTypes() {
            }
        }
        ret.addMixIn(VRObject.class, NoTypes.class);
        ClassUtil.findSubclasses(VRObject.class).forEach(c -> ret.registerSubtypes(new Class[]{c}));
        ret.setAnnotationIntrospector((AnnotationIntrospector)new JacksonAnnotationIntrospector(){
            private static final long serialVersionUID = 1L;

            public boolean hasIgnoreMarker(AnnotatedMember m) {
                return super.hasIgnoreMarker(m) || m.hasAnnotation(Private.class);
            }
        });
        return ret;
    }

    @Bean
    public Jackson2ObjectMapperBuilder objectMapperBuilder() {
        Jackson2ObjectMapperBuilder builder = new Jackson2ObjectMapperBuilder();
        builder.featuresToEnable(new Object[]{DeserializationFeature.USE_LONG_FOR_INTS});
        builder.deserializerByType(String.class, (JsonDeserializer)new SanitizeStringDeserializer());
        builder.serializerByType(String.class, (JsonSerializer)new SanitizeStringSerializer());
        builder.featuresToDisable(new Object[]{SerializationFeature.WRITE_DATES_AS_TIMESTAMPS});
        JavaTimeModule module = new JavaTimeModule();
        module.addDeserializer(LocalDate.class, (JsonDeserializer)new LocalDateDeserializer(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        module.addSerializer(LocalDate.class, (JsonSerializer)new LocalDateSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd")));
        module.addDeserializer(LocalDateTime.class, (JsonDeserializer)new LocalDateTimeDeserializer(DateTimeFormatter.ofPattern("yyyy-MM-dd['T'HH:mm[:ss[.SSSSSSSSS]]]")));
        module.addSerializer(LocalDateTime.class, (JsonSerializer)new LocalDateTimeSerializer(DateTimeFormatter.ofPattern("yyyy-MM-dd['T'HH:mm[:ss[.SSSSSSSSS]]]")));
        builder.modules(new Module[]{module});
        return builder;
    }

    private String removeHtmlTags(String arg) {
        return this.htmlTag.matcher(arg).replaceAll("");
    }

    public class SanitizeStringDeserializer
    extends StdScalarDeserializer<String> {
        private static final long serialVersionUID = 1L;

        protected SanitizeStringDeserializer() {
            super(String.class);
        }

        public String deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return JacksonConfig.this.removeHtmlTags(p.getText());
        }
    }

    public class SanitizeStringSerializer
    extends StdScalarSerializer<String> {
        private static final long serialVersionUID = 1L;

        public SanitizeStringSerializer() {
            super(String.class);
        }

        public void serialize(String value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            String clean = JacksonConfig.this.removeHtmlTags(value);
            gen.writeString(clean);
        }
    }
}

