/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.PostConstruct;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import nl.martijndwars.webpush.Notification;
import nl.martijndwars.webpush.PushService;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.vrspace.server.core.GroupRepository;
import org.vrspace.server.core.NotFoundException;
import org.vrspace.server.core.VRObjectRepository;
import org.vrspace.server.core.WorldManager;
import org.vrspace.server.dto.GroupEvent;
import org.vrspace.server.dto.WebPushMessage;
import org.vrspace.server.obj.Client;
import org.vrspace.server.obj.GroupMember;
import org.vrspace.server.obj.GroupMessage;
import org.vrspace.server.obj.Ownership;
import org.vrspace.server.obj.UserGroup;
import org.vrspace.server.obj.WebPushSubscription;
import org.vrspace.server.obj.World;

@Component
@Lazy
public class GroupManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GroupManager.class);
    @Autowired
    private VRObjectRepository db;
    @Autowired
    private GroupRepository groupRepo;
    @Autowired
    private WorldManager worldManager;
    @Autowired(required=false)
    private PushService pushService;
    @Autowired
    private ObjectMapper objectMapper;
    private static GroupManager instance;

    public static GroupManager getInstance() {
        return instance;
    }

    @PostConstruct
    public void init() {
        instance = this;
    }

    @Transactional
    public List<UserGroup> listGroups(Client client) {
        return this.groupRepo.listUserGroups(client.getId());
    }

    @Transactional
    public List<UserGroup> listOwnedGroups(Client client) {
        return this.groupRepo.listOwnedGroups(client.getId());
    }

    @Transactional
    public UserGroup createGroup(Client client, UserGroup group) {
        if (this.groupRepo.findGroup((long)client.getId(), group.getName()).isPresent()) {
            throw new IllegalArgumentException("Client already belongs to group " + group.getName());
        }
        group = (UserGroup)this.db.save(group);
        this.addOwner(group, client);
        this.addMember(group, client);
        return group;
    }

    @Transactional
    public UserGroup updateGroup(Client client, UserGroup group) {
        if (this.db.getOwnership(client.getId(), group.getId()) == null) {
            throw new SecurityException("Not an owner");
        }
        group = (UserGroup)this.db.save(group);
        return group;
    }

    @Transactional
    public void deleteGroup(Client client, UserGroup group) {
        if (this.db.getOwnership(client.getId(), group.getId()) == null) {
            throw new SecurityException("Not an owner");
        }
        this.groupRepo.messagesSince(group.getId(), null).forEach(groupMessage -> this.db.delete(groupMessage));
        this.groupRepo.listGroupMembers(group.getId()).forEach(groupMember -> this.db.delete(groupMember));
        this.db.getOwnersOf(group.getId()).forEach(ownership -> this.db.delete(ownership));
        this.db.delete(group);
    }

    @Transactional
    public List<Client> show(UserGroup group) {
        return this.groupRepo.listGroupClients(group.getId());
    }

    @Transactional
    public void invite(UserGroup group, Long memberId, Client owner) {
        this.invite(group, this.getClient(memberId), owner);
    }

    @Transactional
    public void invite(UserGroup group, Client member, Client owner) {
        if (this.groupRepo.findGroupMember(group.getId(), member.getId()).isPresent()) {
            throw new IllegalArgumentException("Client " + member.getId() + " is already member of group " + group.getId());
        }
        if (group.isPrivate() && (owner == null || this.db.findOwnership(owner.getId(), group.getId()).isEmpty())) {
            throw new IllegalArgumentException("Only group owners can invite members");
        }
        GroupMember gm = new GroupMember(group, member).invite(owner);
        this.save(gm);
        Client cachedClient = this.worldManager.getCachedClient(member);
        if (cachedClient != null) {
            cachedClient.sendMessage(GroupEvent.invite(gm));
        } else if (this.pushService != null) {
            log.debug("Pushing invite for offline client:" + member);
            WebPushMessage msg = new WebPushMessage();
            msg.setType(WebPushMessage.Type.GROUP_INVITE);
            msg.setGroupId(group.getId());
            msg.setGroupName(group.getName());
            msg.setSender(owner.getName());
            this.notify(member, msg);
        } else {
            log.debug("Invite for offline client:" + member);
        }
    }

    @Transactional
    public void accept(UserGroup group, Client member) {
        Optional<GroupMember> existingMember = this.groupRepo.findGroupMember(group.getId(), member.getId());
        if (existingMember.isEmpty() || existingMember.get().getPendingInvite() == null) {
            throw new IllegalArgumentException("Not invited client: " + member.getId());
        }
        GroupMember updatedMember = ((GroupMember)this.db.get(existingMember)).accept();
        this.save(updatedMember);
    }

    @Transactional
    public void ask(UserGroup group, Client member) {
        if (this.groupRepo.findGroupMember(group.getId(), member.getId()).isPresent()) {
            throw new IllegalArgumentException("Client " + member.getId() + " is already joining group " + group.getId());
        }
        GroupMember gm = new GroupMember(group, member).request();
        this.save(gm);
        this.groupRepo.listGroupOwners(group.getId()).forEach(client -> {
            Client cachedClient = this.worldManager.getCachedClient((Client)client);
            if (cachedClient != null) {
                cachedClient.sendMessage(GroupEvent.ask(gm));
            } else if (this.pushService != null) {
                log.debug("Pushing message for offline client:" + client);
                WebPushMessage msg = new WebPushMessage();
                msg.setType(WebPushMessage.Type.GROUP_ASK);
                msg.setGroupId(group.getId());
                msg.setGroupName(group.getName());
                msg.setSender(member.getName());
                this.notify((Client)client, msg);
            }
        });
    }

    @Transactional
    public void allow(UserGroup group, Long memberId, Client owner) {
        this.allow(group, this.getClient(memberId), owner);
    }

    @Transactional
    public void allow(UserGroup group, Client member, Client owner) {
        if (this.db.findOwnership(owner.getId(), group.getId()).isEmpty()) {
            throw new IllegalArgumentException("Only group owners can allow members");
        }
        Optional<GroupMember> asked = this.groupRepo.findGroupMember(group.getId(), member.getId());
        if (asked.isPresent()) {
            GroupMember gm = (GroupMember)this.db.get(asked);
            if (gm.getPendingRequest() == null) {
                throw new IllegalArgumentException("No pending request for client: " + member.getId());
            }
            this.save(gm.allow(owner));
            Client cachedClient = this.worldManager.getCachedClient(member);
            if (cachedClient != null) {
                cachedClient.sendMessage(GroupEvent.allow(gm));
            } else if (this.pushService != null) {
                log.debug("Pushing message for offline client:" + member);
                WebPushMessage msg = new WebPushMessage();
                msg.setType(WebPushMessage.Type.GROUP_ALLOWED);
                msg.setGroupId(group.getId());
                msg.setGroupName(group.getName());
                msg.setSender(member.getName());
                this.notify(member, msg);
            }
        } else {
            throw new IllegalArgumentException("Client did not ask to join: " + member.getId());
        }
    }

    @Transactional
    public void join(UserGroup group, Client member) {
        if (group.isPrivate()) {
            throw new IllegalArgumentException("Ask to join a private group");
        }
        Optional<GroupMember> existing = this.groupRepo.findGroupMember(group.getId(), member.getId());
        if (existing.isPresent()) {
            throw new IllegalArgumentException("Already a member");
        }
        this.addMember(group, member);
    }

    @Transactional
    public void leave(UserGroup group, Client member) {
        if (this.db.findOwnership(member.getId(), group.getId()).isPresent()) {
            throw new IllegalArgumentException("Group owners can not leave their groups");
        }
        this.removeMember(group, member);
    }

    @Transactional
    public void kick(UserGroup group, long memberId, Client owner) {
        Optional<GroupMember> member = this.groupRepo.findGroupMember(group.getId(), memberId);
        if (member.isEmpty()) {
            throw new IllegalArgumentException("Group does not contain client: " + memberId);
        }
        this.kick(group, member.get().getClient(), owner);
    }

    @Transactional
    public void kick(UserGroup group, Client member, Client owner) {
        if (!group.isPrivate()) {
            throw new IllegalArgumentException("Can't kick members from public groups");
        }
        if (this.db.findOwnership(owner.getId(), group.getId()).isEmpty()) {
            throw new SecurityException("Only group owners can kick members");
        }
        this.removeMember(group, member);
    }

    @Transactional
    public List<GroupMember> pendingRequests(UserGroup group, Client member) {
        if (this.db.findOwnership(member.getId(), group.getId()).isEmpty()) {
            throw new SecurityException("Only group owners can list pending requets");
        }
        return this.groupRepo.listPendingRequests(group.getId());
    }

    @Transactional
    public List<GroupMember> pendingInvitations(Client member) {
        return this.groupRepo.listPendingInvitations(member.getId());
    }

    private void addMember(UserGroup group, Client member) {
        GroupMember gm = new GroupMember(group, member);
        this.save(gm);
    }

    private void removeMember(UserGroup group, Client member) {
        this.groupRepo.findGroupMember(group.getId(), member.getId()).ifPresent(groupMember -> this.db.delete(groupMember));
    }

    @Transactional
    public void addOwner(UserGroup group, Client owner) {
        Ownership ownership = new Ownership(owner, group);
        this.db.save(ownership);
    }

    @Transactional
    public void removeOwner(UserGroup group, Client owner) {
        this.db.findOwnership(owner.getId(), group.getId()).ifPresent(ownership -> this.db.delete(ownership));
    }

    private void write(Client sender, UserGroup group, WebPushMessage.Type type, GroupMessage groupMessage) {
        if (this.groupRepo.findGroupMember(group.getId(), sender.getId()).isEmpty()) {
            throw new SecurityException("Only members can post to groups");
        }
        groupMessage.setGroup(group);
        GroupMessage message = (GroupMessage)this.db.save(groupMessage);
        this.groupRepo.listGroupClients(group.getId()).forEach(client -> {
            Client cachedClient = this.worldManager.getCachedClient((Client)client);
            if (cachedClient != null) {
                cachedClient.sendMessage(GroupEvent.message(message));
            } else if (this.pushService != null) {
                log.debug("Pushing message for offline client:" + client);
                WebPushMessage msg = new WebPushMessage();
                msg.setType(type);
                msg.setWorldId(message.getWorldId());
                msg.setGroupId(group.getId());
                msg.setGroupName(group.getName());
                msg.setSender(sender.getName());
                msg.setMessage(message.getContent());
                msg.setUrl(message.getLink());
                this.notify((Client)client, msg);
            }
        });
    }

    @Transactional
    public void write(Client sender, UserGroup group, String text) {
        this.write(sender, group, WebPushMessage.Type.GROUP_MESSAGE, new GroupMessage(sender, group, text, Instant.now()));
    }

    @Transactional
    public void worldInvite(Client sender, UserGroup group, String worldName, String link) {
        GroupMessage msg = new GroupMessage(sender, group, worldName, Instant.now());
        msg.setLink(link);
        msg.setLocal(true);
        World world = this.worldManager.getWorld(worldName);
        if (world == null) {
            throw new IllegalArgumentException("Unknown world " + worldName);
        }
        msg.setWorldId(world.getId());
        this.write(sender, group, WebPushMessage.Type.WORLD_INVITE, msg);
    }

    @Transactional
    public UserGroup getGroup(Client client, String name) {
        Optional<UserGroup> group = this.groupRepo.findGroup((long)client.getId(), name);
        if (group.isEmpty()) {
            throw new NotFoundException("Non-existing group: " + name + " clientId:" + client.getId());
        }
        return group.get();
    }

    @Transactional
    public UserGroup getGroup(Client client, long groupId) {
        Optional<UserGroup> group = this.groupRepo.findGroup((long)client.getId(), groupId);
        if (group.isEmpty()) {
            throw new NotFoundException("Non-existing group: " + groupId + " clientId:" + client.getId());
        }
        return group.get();
    }

    @Transactional
    public UserGroup getGroup(long groupId) {
        UserGroup group = (UserGroup)this.db.get(UserGroup.class, groupId);
        if (group == null) {
            throw new NotFoundException("Non-existing group: " + groupId);
        }
        return group;
    }

    @Transactional
    public List<UserGroup> unreadGroups(Client client) {
        List<GroupMember> groups = this.groupRepo.listGroupMemberships(client.getId());
        groups.forEach(gm -> {
            UserGroup group = gm.getGroup();
            int unread = this.groupRepo.unreadMessageCount(group.getId(), gm.getLastRead());
            group.setUnread(unread);
        });
        return groups.stream().map(gm -> gm.getGroup()).filter(g -> g.getUnread() > 0).collect(Collectors.toList());
    }

    @Transactional
    public List<GroupMessage> unreadMessages(Client client, UserGroup group) {
        Instant now = Instant.now();
        Optional<GroupMember> gm = this.groupRepo.findGroupMember(group.getId(), client.getId());
        if (gm.isEmpty()) {
            throw new NotFoundException("Not a group member: " + group.getId() + " clientId:" + client.getId());
        }
        GroupMember member = gm.get();
        Instant lastRead = member.getLastRead();
        member.setLastRead(now);
        this.save(member);
        return this.groupRepo.messagesSince(group.getId(), lastRead);
    }

    @Transactional
    public List<Client> listOwners(UserGroup group) {
        return this.db.getOwners(group.getId()).stream().map(ownership -> ownership.getOwner()).toList();
    }

    private Client getClient(long clientId) {
        Client client = this.db.getClient(clientId);
        if (client == null) {
            throw new NotFoundException("Non-existing client: " + clientId);
        }
        return client;
    }

    private void save(GroupMember gm) {
        this.db.save(gm);
    }

    private void notify(Client client, WebPushMessage msg) {
        this.db.listSubscriptions(client.getId()).forEach(sub -> this.send((WebPushSubscription)sub, msg));
    }

    private void send(WebPushSubscription subscription, WebPushMessage message) {
        try {
            Notification notification = new Notification(subscription.getEndpoint(), subscription.getKey(), subscription.getAuth(), this.objectMapper.writeValueAsBytes((Object)message));
            HttpResponse res = this.pushService.send(notification);
            log.debug("Notification sent:" + message + " to " + subscription.getEndpoint() + " result: " + res + " " + EntityUtils.toString((HttpEntity)res.getEntity(), (String)"UTF-8"));
            if (res.getStatusLine().getStatusCode() != 201) {
                log.error("Push notification failed");
            }
        }
        catch (Exception e) {
            log.error("Push notification failed", (Throwable)e);
        }
    }
}

