/*
 * Decompiled with CFR 0.152.
 */
package org.vrspace.server.dto;

import lombok.Generated;
import lombok.NonNull;
import org.vrspace.server.core.WorldManager;
import org.vrspace.server.dto.ClientResponse;
import org.vrspace.server.dto.Command;
import org.vrspace.server.dto.Welcome;
import org.vrspace.server.obj.Client;

public class Enter
implements Command {
    @NonNull
    private String world;
    private String token;
    private boolean async = true;

    @Override
    public ClientResponse execute(WorldManager manager, Client client) throws ClassNotFoundException {
        if (this.token != null) {
            client.setToken(this.world, this.token);
        }
        Welcome welcome = manager.enter(client, this.world);
        if (this.async) {
            client.sendMessage(welcome);
            return null;
        }
        return new ClientResponse(welcome);
    }

    @NonNull
    @Generated
    public String getWorld() {
        return this.world;
    }

    @Generated
    public String getToken() {
        return this.token;
    }

    @Generated
    public boolean isAsync() {
        return this.async;
    }

    @Generated
    public void setWorld(@NonNull String world) {
        if (world == null) {
            throw new NullPointerException("world is marked non-null but is null");
        }
        this.world = world;
    }

    @Generated
    public void setToken(String token) {
        this.token = token;
    }

    @Generated
    public void setAsync(boolean async) {
        this.async = async;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Enter)) {
            return false;
        }
        Enter other = (Enter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAsync() != other.isAsync()) {
            return false;
        }
        String this$world = this.getWorld();
        String other$world = other.getWorld();
        if (this$world == null ? other$world != null : !this$world.equals(other$world)) {
            return false;
        }
        String this$token = this.getToken();
        String other$token = other.getToken();
        return !(this$token == null ? other$token != null : !this$token.equals(other$token));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Enter;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAsync() ? 79 : 97);
        String $world = this.getWorld();
        result = result * 59 + ($world == null ? 43 : $world.hashCode());
        String $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Enter(world=" + this.getWorld() + ", token=" + this.getToken() + ", async=" + this.isAsync() + ")";
    }

    @Generated
    public Enter() {
    }

    @Generated
    public Enter(@NonNull String world) {
        if (world == null) {
            throw new NullPointerException("world is marked non-null but is null");
        }
        this.world = world;
    }

    @Generated
    public Enter(@NonNull String world, String token, boolean async) {
        if (world == null) {
            throw new NullPointerException("world is marked non-null but is null");
        }
        this.world = world;
        this.token = token;
        this.async = async;
    }
}

